<?php 
class cDocumento extends mDocumento {
    public function verificarDocumento()
    {
        $codeExists = $this->buscarCodigoDocumento();
        $message = 'Código registrado para otro documento';
        if (empty($codeExists)) {
            $nameExists = $this->buscarNombreDocumento($this->nombre);
            if (empty($nameExists)) {
                return ['status' => 'success'];
            }
            $message = 'Nombre registrado para otro documento';
        }
        return ['status' => 'error', 'message' => $message];
    }

    public function subirDocumento()
    {
        $path = '../../../doc';
        if (!file_exists($path)) {
			mkdir($path, 0775, true);
		}
        $archivo = $_FILES['documento'];
        $nombreDocumento = $this->nombre_archivo;
        $invalido = $this->validarDocumento($archivo, $nombreDocumento);
        if (!empty($invalido)) {
            return ['status' => 'error', 'message' => $invalido];
        } else {
            $response = ['status' => 'success'];
            if (!empty($archivo['name'])) {
                $extension = $this->extensionDocumento($archivo);
                $nombreArchivo = !empty($nombreDocumento) ? $nombreDocumento : uniqid().'.'.$extension;
                $ruta = $path.'/'.$nombreArchivo;
                if(move_uploaded_file($archivo['tmp_name'], $ruta)) {
                    $response = ['status' => 'success', 'nombre' => $nombreArchivo];
                } else {
                    $response = ['status' => 'error', 'message' => 'No se pudo subir el documento'];
                }
            }
            return $response;
        }
    }

    public function validarDocumento($archivo, $nombreDocumento)
    {
        $message = '';
        if (empty($archivo['name']) && empty($nombreDocumento)) {
            $message = 'El documento es obligatorio';
        } elseif (!empty($archivo['name'])) {
            $extension = $this->extensionDocumento($archivo);
            if (!in_array($extension, ['doc','docx'])) {
                $message = 'Tipo de documento inválido';
            }
        }
        return $message;
    }

    public function extensionDocumento($archivo)
    {
        return pathinfo($archivo['name'], PATHINFO_EXTENSION);
    }
}