<?php 

	class mconstancia
	{
		
		function __clone() {

		} #clone

		function __construct() {
			$this->dbh = new Conexion();
			$this->con = $this->dbh->pgsql();
			$this->msj = array();
			if(isset($_POST)) {
				foreach($_POST as $indice=>$valor) {
					if(!is_array($valor)) {
						$this->$indice = strtoupper($valor);
					}
				}
			}
		} #construct

		function constanciaSelectCedrif($cedrif) {
			$sql = "SELECT * FROM tbl_constancia WHERE constancia_paciente=? ORDER BY constancia_ide DESC";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$cedrif);
			$res->execute();
			return $res->fetchAll(PDO::FETCH_OBJ);
		}

		function constanciaSelectIde($ide) {
			$sql = "SELECT * FROM tbl_constancia WHERE constancia_ide=? ORDER BY constancia_ide DESC";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$ide);
			$res->execute();
			return $res->fetchAll(PDO::FETCH_OBJ);
		}

		function odontologosLista(){
			$sql = "SELECT * FROM vw_selecmedicos WHERE (nivusuario_codigo=2 or nivusuario_codigo=3) ORDER BY pacien_nomraz DESC";
			$res = $this->con->prepare($sql);
			$res->execute();
			return $res->fetchAll(PDO::FETCH_OBJ);
		}

		function odontologosListaIde($cedrif){
			$sql = "SELECT * FROM vw_selecmedicos WHERE (nivusuario_codigo=2 or nivusuario_codigo=3) and pacien_cedrif=? ORDER BY pacien_nomraz DESC";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$cedrif);
			$res->execute();
			return $res->fetchAll(PDO::FETCH_OBJ);
		}

		function constanciaInsert(){
			$fecha= date('Y-m-d', strtotime($this->fecha));
			$sql = "INSERT INTO tbl_constancia VALUES(null,?,?,?)";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$this->constancia);
			$res->bindParam(2,$this->cedrif);
			$res->bindParam(3,$fecha);
			$rt = ($res->execute()==true) ? 1 : print_r($res->errorInfo());
			$id=$this->con->lastInsertId();
			$this->dbh->sp_auditoria($_SESSION['ced'],1,'tbl_constancia',$id); 
			return $rt;
		}

		function constanciaDelete(){
			$sql = "DELETE FROM tbl_constancia WHERE constancia_ide=?";
			$res = $this->con->prepare($sql);
			$res->bindParam(1,$this->constancia_ide);
			$rt = ($res->execute()==true) ? 1 : print_r($res->errorInfo());
			$this->dbh->sp_auditoria($_SESSION['ced'],3,'tbl_constancia',$this->constancia_ide); 
			return $rt;
		}
	}

?>