<?php 
require '../../../cfg/base.php';
$row_espec = $modonto->getAllEspec();
$plantillas = $mdocumento->plantillasPorTipo(1);
echo $fun->modalHeader('Consentimiento Informado ');
?>

<style>
#firma-paciente {
  border: 2px dotted #CCCCCC;
  border-radius: 5px;
  cursor: crosshair;
}
</style>

<form action="" role="form" class="form-horizontal diagproced">
	<div class="modal-body">
		<div class="msj_20"></div>
		<input type="hidden" name="cedrif" id="cedrif" value="<?php echo $cedrif ?>" >

		<div class="form-group">
			<label for="" class="control-label col-sm-3">Fecha de inicio:</label>
			<div class="col-sm-9">
				<input type="text"  autocomplete="off" class="col-sm-12 fecha" name="fechaDatos" value="<?php echo date("d-m-Y"); ?>">	     
			</div>
		</div>
		<div class="form-group">
			<label for="" class="control-label col-sm-3">Especialidad:</label>
			<div class="col-sm-9"><select name="espec" id="espec" class="col-sm-12 chosen" onchange="loadAdditionalFields($(this).val())">
				<option value=""></option>
				<?php foreach($row_espec as $r) { ?>
					<option value="<?php echo $r->espec_ide ?>"><?php echo $r->espec_descrip; ?></option>
				<?php } ?>
			</select>
		</div>
	</div>
	<div class="form-group" id="proced"></div>

	<div class="form-group" id="dentists"></div>
	
	<div class="form-group">
		<label for="" class="control-label col-sm-3">N° Diente:</label>
		<div class="col-sm-9">	     
			<input type="text" class="col-sm-12" name="numdiente" id="numdiente" value=""> 
		</div>
	</div>
	<div class="form-group">
		<label for="" class="control-label col-sm-3">Anestesia Local:</label>
		<div class="col-sm-9">	     
			<input type="text" class="col-sm-12" name="anlocal" id="anlocal"> 
		</div>
	</div>
	<div class="form-group">
		<label for="" class="control-label col-sm-3">Otras Complicaciones:</label>
		<div class="col-sm-9">	     
			<input type="text" class="col-sm-12" name="otracom" id="otracom"> 
		</div>
	</div>
	<div class="form-group">
		<label for="" class="control-label col-sm-3">Calidad:</label>
		<div class="checkbox checkbox-inline">
			<input type="radio" name="calidad" id="calidad1" value="1" checked="">
			<label for="inlineCheckbox1"> Paciente </label>
		</div>
		<div class="checkbox checkbox-success checkbox-inline">
			<input type="radio" name="calidad" id="calidad2" value="2" >
			<label for="inlineCheckbox2"> Familiar </label>
		</div>
		<div class="checkbox checkbox-inline">
			<input type="radio" name="calidad" id="calidad3" value="3">
			<label for="inlineCheckbox3"> Representante Legal </label>
		</div>
	</div>

	<div class="representante" hidden>
		<div class="form-group">
			<label for="" class="control-label col-sm-3">Nombre del Representante o Familiar:</label>
			<div class="col-sm-9">	     
				<input type="text" class="col-sm-12" name="nombre_representate" id="nombre_representate">
			</div>
		</div>
		<div class="form-group">
			<label for="" class="control-label col-sm-3">Núnero de Identificacion:</label>
			<div class="col-sm-9">	     
				<input type="text" class="col-sm-12" name="nro_identificacion_representate" id="nro_identificacion_representate">
			</div>
		</div>
		<div class="form-group">
			<label for="" class="control-label col-sm-3">Parentesco:</label>
			<div class="col-sm-9">	     
				<input type="text" class="col-sm-12" name="parentesco" id="parentesco">
			</div>
		</div>
	</div>

	<div class="form-group">
		<label for="" class="control-label col-sm-3">Observacion:</label>
		<div class="col-sm-9">	     
			<textarea name="observacion" id="observacion" rows="5" cols="5" class="form-control"></textarea>
		</div>
	</div>
	<div class="form-group">
		<label for="" class="control-label col-sm-3">Tipo:</label>
		<div class="checkbox checkbox-inline">
			<input type="radio" name="tipoform" id="tipoform" value="0" checked="">
			<label for="inlineCheckbox1"> Odontologia </label>
		</div>
		<div class="checkbox checkbox-success checkbox-inline">
			<input type="radio" name="tipoform" id="tipoform" value="1" >
			<label for="inlineCheckbox2"> Endodoncia </label>
		</div>
	</div>
	<div class="form-group">
		<label for="" class="control-label col-sm-3">Plantilla:</label>
		<div class="col-sm-9">
			<select name="documento_id" id="documento_id" class="form-control">
				<option value="">Seleccionar</option>
				<?php if (!empty($plantillas)) {
					foreach ($plantillas as $plantilla) { ?>
						<option value="<?php echo $plantilla->documento_id; ?>"><?php echo $plantilla->nombre; ?></option>
					<?php }
				} ?>
			</select>
		</div>
	</div>
	<div class="form-group">
		<label for="" class="control-label col-sm-3">Firma del Paciente:</label>
		<div class="col-sm-9">
			<canvas id="firma-paciente" width="390" height="150"></canvas>
			<button type="button" class="btn btn-secundary btn-sm" id="clear-fpaciente">Borrar Firma</button>
		</div>
	</div>
	<div class="form-actions modal-footer">
		<input type="hidden" name="img-firma-paciente" id="img-firma-paciente" value="" >
		<button class="btn btn-primary btn-sm pull-right"><span class="i fa fa-check"></span> Guardar Cambios</button>
	</div>
</div>
</form>
<div class="space-10"></div>

<script src="js/firmaCanvas.js"></script>

<script>
	window.requestAnimFrame = (function (callback) {
		return window.requestAnimationFrame ||
					window.webkitRequestAnimationFrame ||
					window.mozRequestAnimationFrame ||
					window.oRequestAnimationFrame ||
					window.msRequestAnimaitonFrame ||
					function (callback) {
					 	window.setTimeout(callback, 1000/60);
            // Retrasa la ejecucion de la funcion para mejorar la experiencia
					};
	})();

	// Traemos el canvas mediante el id del elemento html
	var canvasPaciente = document.getElementById("firma-paciente");
	var ctxPaciente = canvasPaciente.getContext("2d");

	// Mandamos llamar a los Elemetos interactivos de la Interfaz HTML
	var clearBtnPaciente = document.getElementById("clear-fpaciente");
	clearBtnPaciente.addEventListener("click", function (e) {
		// Definimos que pasa cuando el boton draw-clearBtn es pulsado
		clearCanvasPaciente();
	}, false);

	// Activamos MouseEvent para nuestra pagina
	var drawingPaciente = false;
	var mousePosPaciente = { x:0, y:0 };
	var lastPosPaciente = mousePosPaciente;
	canvasPaciente.addEventListener("mousedown", function (e)
  {
		var tint = 'black';
    var punta = 2;
		drawingPaciente = true;
		lastPosPaciente = getMousePosPaciente(canvasPaciente, e);
	}, false);
	canvasPaciente.addEventListener("mouseup", function (e)
  {
		drawingPaciente = false;
	}, false);
	canvasPaciente.addEventListener("mousemove", function (e)
  {
		mousePosPaciente = getMousePosPaciente(canvasPaciente, e);
	}, false);

	// Activamos touchEvent para nuestra pagina
	canvasPaciente.addEventListener("touchstart", function (e) {
		mousePosPaciente = getTouchPosPaciente(canvasPaciente, e);
    e.preventDefault(); // Prevent scrolling when touching the canvas
		var touchPaciente = e.touches[0];
		var mouseEventPaciente = new MouseEvent("mousedown", {
			clientX: touchPaciente.clientX,
			clientY: touchPaciente.clientY
		});
		canvasPaciente.dispatchEvent(mouseEventPaciente);
	}, false);
	canvasPaciente.addEventListener("touchend", function (e) {
    e.preventDefault(); // Prevent scrolling when touching the canvas
		var mouseEventPaciente = new MouseEvent("mouseup", {});
		canvasPaciente.dispatchEvent(mouseEventPaciente);
	}, false);
  canvasPaciente.addEventListener("touchleave", function (e) {
    // Realiza el mismo proceso que touchend en caso de que el dedo se deslice fuera del canvas
    e.preventDefault(); // Prevent scrolling when touching the canvas
    var mouseEventPaciente = new MouseEvent("mouseup", {});
    canvasPaciente.dispatchEvent(mouseEventPaciente);
  }, false);
	canvasPaciente.addEventListener("touchmove", function (e) {
    e.preventDefault(); // Prevent scrolling when touching the canvas
		var touchPaciente = e.touches[0];
		var mouseEventPaciente = new MouseEvent("mousemove", {
			clientX: touchPaciente.clientX,
			clientY: touchPaciente.clientY
		});
		canvasPaciente.dispatchEvent(mouseEventPaciente);
	}, false);

	// Get the position of the mouse relative to the canvas
	function getMousePosPaciente(canvasDom, mouseEvent) {
		var rect = canvasDom.getBoundingClientRect();
		return {
			x: mouseEvent.clientX - rect.left,
			y: mouseEvent.clientY - rect.top
		};
	}

	// Get the position of a touch relative to the canvas
	function getTouchPosPaciente(canvasDom, touchEvent) {
		var rect = canvasDom.getBoundingClientRect();
		return {
			x: touchEvent.touches[0].clientX - rect.left, // Popiedad de todo evento Touch
			y: touchEvent.touches[0].clientY - rect.top
		};
	}

	// Draw to the canvas
	function renderCanvasPaciente() {
		if (drawingPaciente) {
      var tint = 'black';
      var punta = 2;
      ctxPaciente.strokeStyle = tint;
      ctxPaciente.beginPath();
			ctxPaciente.moveTo(lastPosPaciente.x, lastPosPaciente.y);
			ctxPaciente.lineTo(mousePosPaciente.x, mousePosPaciente.y);
    	ctxPaciente.lineWidth = punta;
			ctxPaciente.stroke();
      ctxPaciente.closePath();
			lastPosPaciente = mousePosPaciente;
		}
	}

	function clearCanvasPaciente() {
		canvasPaciente.width = canvasPaciente.width;
	}

	// Allow for animation
	(function drawLoop () {
		requestAnimFrame(drawLoop);
		renderCanvasPaciente();
	})();

	$('#espec').chosen({width: "inherit",no_results_text:'No hay resultados'});
	load('app/consenti/vistas/cargar.proced.php','select=&espec=&disabled=','#proced');
	
	$(function(){
		$('input:radio[name=calidad]').on('click', function () {
		if (['2','3'].includes($(this).val())) {
			$('.representante').show();
		} else {
			$('.representante').hide();
			$('#nombre_representate').val('');
			$('#nro_identificacion_representate').val('');
			$('#parentesco').val('');
		}
	})

		$('.diagproced').validate({
			errorElement: 'div',
			errorClass: 'help-block',
			focusInvalid: true,
			rules: {
				diagproced: {
					required: true
				},
				espec: {
					required: true
				}

			},
			messages: {
				diagproced: {
					required: 'Indique el procedimiento'
				},
				espec: {
					required: 'Indique la especialidad'
				}
			},

			invalidHandler: function (event, validator) { 
				$('.alert-danger', $('.diagproced')).show();
			},			
			highlight: function (e) {
				$(e).closest('.form-group').removeClass('has-info').addClass('has-error');
			},
			success: function (e) {
				$(e).closest('.form-group').removeClass('has-error').addClass('has-info');
				$(e).remove();
			},
			
			submitHandler: function (form) {
				var canvasPaciente = document.getElementById("firma-paciente");
				var imagePaciente = canvasPaciente.toDataURL();
				document.getElementById('img-firma-paciente').value = imagePaciente;

				if ($('#espec').val() == '') {
					alerta('.msj_20','danger','Seleccione una especialidad');
					return false;
				}
				if (!$('#diagproced').val()) {
					alerta('.msj_20','danger','Seleccione al menos un Procedimiento');
					return false;
				}

				var formData = new FormData(form);

				$.ajax({
					url: 'app/consenti/procesos/insert.consenti.php',
					type: 'POST',
					data: formData,
					cache: false,
					contentType: false,
					processData: false,
					success: function (data) {
						if (data.status == 'error') {
							alerta('.msjerror','danger',data.message);
							return false;
						}
						alert('Registro Realizado');
						load('app/consenti/vistas/consenti.lista.php','cedrif='+$('#cedrif').val(),'.lista-consenti');
						cerrarmodal();
					}
				});
			},
			invalidHandler: function (form) {
			}
		})

	})
	function enviar() {
		$('.diagproced').submit();
	};
	$(function(){
		$('.fecha').datepicker({format:'dd-mm-yyyy',autoclose:"true"});
	})
	function loadAdditionalFields(specialtyId) {
		load('app/evolgeneral/vistas/cargar.proced.php','select=&disabled=1&espec='+specialtyId,'#proced');
		load('app/consenti/vistas/cargar.selector.odontologos.php','espec='+specialtyId,'#dentists')
	}
</script>
