<?php 
require '../../../cfg/base.php';
$consenti = $mconsenti->insertConsenti();

if ($consenti['status'] == 'success') {
  $ced = $_POST['cedrif'];
  $path = str_replace('\\','/',__DIR__);
  $dir = explode('app/', $path);
  $plantilla = $mdocumento->obtenerArchivoPlantilla($_POST['documento_id']);
  $paciente = $musuarios->buscarPaciente($ced);
  $odontologo = $musuarios->datosOdontologo($_POST['odontologo']);
  $dirTmp = sys_get_temp_dir();

  $firmaPaciente = $_POST['img-firma-paciente'];
  $firmaPaciente = str_replace('data:image/png;base64,', '', $firmaPaciente);
  $contentFirmaPaciente = base64_decode($firmaPaciente);
  $tmpPaciente = tempnam($dirTmp, "foo");
  file_put_contents($tmpPaciente, $contentFirmaPaciente);

  $edad = '';
  if (!empty($paciente[0]->pacien_fechnac)) {
    $nacimiento = new DateTime($paciente[0]->pacien_fechnac);
    $ahora = new DateTime(date("Y-m-d"));
    $diferencia = $ahora->diff($nacimiento);
    $edad = $diferencia->format("%y");
  }


  $informacionDocumento = [
    'FECHA' => date('d-m-Y'),
    'NOMBRE_COMPLETO' => $paciente[0]->pacien_nomraz,
    'NRO_DOCUMENTO_IDENTIDAD' => $ced,
    'TIPO_DOCUMENTO_IDENTIDAD' => $paciente[0]->pacien_nac,
    'SEXO' => $paciente[0]->pacien_sexo,
    'EDAD' => $edad,
    'CELULAR' => $paciente[0]->pacien_movil1tlf,
    'TELEFONO' => $paciente[0]->pacien_casatlf,
    'CORREO_ELECTRONICO' => $paciente[0]->pacien_email,
    'DIRECCION' => $paciente[0]->pacien_domicasa,
    'CIUDAD_MUNICIPIO' => '',
    'PROCEDIMIENTO' => $_POST['diagproced'][0],
    'ANESTESIA_LOCAL' => $_POST['anlocal'],
    'NRO_DIENTE' => $_POST['anlocal'],
    'REPRESENTANTE' => $_POST['nombre_representate'],
    'NRO_IDENTIFICACION_REPRESENTANTE' => $_POST['nro_identificacion_representate'],
    'PARENTESCO' => $_POST['parentesco'],
    'NOMBRE_DOCTOR' => $odontologo[0]->pacien_nomraz,
    'FIRMA_PACIENTE' => ($_POST['calidad'] == 1) ? $tmpPaciente : '',
    'FIRMA_REPRESENTANTE' => (in_array($_POST['calidad'], [2,3])) ? $tmpPaciente : '',
    'FIRMA_DOCTOR' => (!empty($odontologo[0]->usuario_imagen_firma)) ? $dir[0].'img/firmas/'.$odontologo[0]->usuario_imagen_firma : ''
  ];

  $file = $dir[0].'doc/'.$plantilla[0]->archivo;
  $consentimiento = true;

  include '../../documentos/procesos/p.procesar.documento.php';

  $mconsenti->agregarArchivo($fileNameDocx, $consenti['id']);
}