<?php 
class mCompra {

	protected $dbh,$con,$msj;

	function __clone() {

	} #clone

	function __construct() {
		$this->dbh = new Conexion();
		$this->con = $this->dbh->pgsql();
		$this->msj = array();
		if(isset($_POST)) {
			foreach($_POST as $indice=>$valor) {
				if(!is_array($valor)) {
					$this->$indice = strtoupper($valor);
				}
			}
		}
	} #construct


	function datosProveedorSelect($cedrif) {
		$sql = "SELECT * FROM tbl_proveedores WHERE proveedor_cedrif=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function compraInserttemp() { 
		$datos = explode('-', $this->cedrif);
		// echo 'cedula= '.$datos[0].' nombre= '.$datos[1].' historia= '.$datos[2];
		$sql = "SELECT fn_compra_temp(null,?,?,0,0,0,0,0,0,1,?) as compra_temp";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$_SESSION['ced']);
		$res->bindParam(2,$datos[0]);
		$res->bindParam(3,$_SESSION['ced']);
		$res->execute();
		$result = $res->fetchAll(PDO::FETCH_OBJ);
		// print_r($result);
		if ($result[0]->compra_temp == 1) {
			$rt = 1;
		}else{
			$rt = 0;
		}
		return $rt;
	}

	function compraDetaInserttemp() { 
		// $datos = explode('-', $this->ide);
		$sql = "SELECT fn_compradeta_temp(null,?,?,0,?,?,1,?) as compradeta_temp";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->compra);
		$res->bindParam(2,$this->ide_produc);
		$res->bindParam(3,$this->cant);
		$res->bindParam(4,$this->costo);
		$res->bindParam(5,$_SESSION['ced']);
		$res->execute();
		$result = $res->fetchAll(PDO::FETCH_OBJ);
		if ($result[0]->compradeta_temp == 1) {
			$rt = 1;
		}else{
			$rt = 0;
		}
		return $rt;
	}

	function compraDefiInsert() { 
		$fecha = date('Y-m-d',strtotime($this->fechcomp));
		$sql = "SELECT fn_compra(?,?,?,?,0,?,?,?,?,1,?) as compra";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->compra);
		$res->bindParam(2,$_SESSION['ced']);
		$res->bindParam(3,$this->provee);
		$res->bindParam(4,$this->facnum);
		$res->bindParam(5,$fecha);
		$res->bindParam(6,$this->subtotal);
		$res->bindParam(7,$this->totaliva);
		$res->bindParam(8,$this->total);
		$res->bindParam(9,$_SESSION['ced']);
		$res->execute();
		$result = $res->fetchAll(PDO::FETCH_OBJ);

		// Insertar detalle de compra
		$row = $this->compraDetaSelect($this->compra);
		foreach ($row as $r) {
			$sql1 = "SELECT fn_compradeta(null,?,?,0,?,?,?,1,?) as compradeta";
			$res1 = $this->con->prepare($sql1);
			$res1->bindParam(1,$result[0]->compra);
			$res1->bindParam(2,$r->compradeta_produc);
			$res1->bindParam(3,$r->compradeta_cant);
			$res1->bindParam(4,$r->compradeta_costo);
			$res1->bindParam(5,$r->compradeta_monto);
			$res1->bindParam(6,$_SESSION['ced']);
			$res1->execute();
			$result1 = $res1->fetchAll(PDO::FETCH_OBJ);
		}
		$delet_comp_temp = $this->deleteCompraTemp($this->compra);
		$delet_comp_temp = $this->deleteCompraDetaTemp($this->compra);

		if (($result[0]->compra != 0) && ($result1[0]->compradeta == 1) && ($delet_comp_temp == 1) && $delet_comp_temp == 1) {
			$rt = 1;
		}else{
			$rt = 0;
		}
		return $rt;
	}

	function deleteCompraTemp($compra) { 
		$sql = "SELECT fn_compradeta_temp(0,?,0,0,0,0,5,?) as compradeta_temp";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$compra);
		$res->bindParam(2,$_SESSION['ced']);
		$res->execute();
		$result = $res->fetchAll(PDO::FETCH_OBJ);
		if ($result[0]->compradeta_temp == 1) {
			$rt = 1;
		}else{
			$rt = 0;
		}
		return $rt;
	}

	function deleteCompraDetaTemp($compra) {
		$sql = "SELECT fn_compra_temp(?,0,0,0,0,0,0,0,0,5,?) as compra_temp";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$compra);
		$res->bindParam(2,$_SESSION['ced']);
		$res->execute();
		$result = $res->fetchAll(PDO::FETCH_OBJ);
		if ($result[0]->compra_temp == 1) {
			$rt = 1;
		}else{
			$rt = 0;
		}
		return $rt;
	}
	// Seleccionar id de la ultima compra en tabla compra_temp 
	function compraSelectLast() {
		$sql = "SELECT * FROM tbl_compra_temp WHERE compra_anulada=0 ORDER BY compra_ide DESC LIMIT 1";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function compraDetaSelect($compra) {
		$sql = "SELECT * FROM tbl_compra_deta_temp WHERE compradeta_compra=? ORDER BY compradeta_ide ASC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$compra);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function selectCompraDeta($compra) {
		$sql = "SELECT * FROM vw_compradeta_temp WHERE compradeta_compra=? and compradeta_borrado=0 ORDER BY compradeta_ide ASC";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$compra);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function selectCompraDetaUpda($ide) {
		$sql = "SELECT * FROM vw_compradeta_temp WHERE compradeta_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function compradetaUpdate() { 
		$sql = "SELECT fn_compradeta_temp(?,0,0,0,?,?,2,?) as compradeta_temp";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$res->bindParam(2,$this->cant);
		$res->bindParam(3,$this->costo);
		$res->bindParam(4,$_SESSION['ced']);
		$res->execute();
		$result = $res->fetchAll(PDO::FETCH_OBJ);
		if ($result[0]->compradeta_temp == 1) {
			$rt = 1;
		}else{
			$rt = 0;
		}
		return $rt;
	}

	function compradetaDelete() { 
		$sql = "SELECT fn_compradeta_temp(?,0,0,0,0,0,3,?) as compradeta_temp";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->ide);
		$res->bindParam(2,$_SESSION['ced']);
		$res->execute();
		$result = $res->fetchAll(PDO::FETCH_OBJ);
		if ($result[0]->compradeta_temp == 1) {
			$rt = 1;
		}else{
			$rt = 0;
		}
		return $rt;
	}

	function compraTotales($compra) { 
		$sql = "SELECT Count(vw_compradeta_temp_totales.compradeta_ide) AS Elementos, Sum(vw_compradeta_temp_totales.Base_Imponible) AS SubTotal, Sum(vw_compradeta_temp_totales.Impuesto) AS TotalImpuesto, Sum(vw_compradeta_temp_totales.compradeta_monto) AS Total FROM vw_compradeta_temp_totales WHERE compradeta_compra=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->compra);
		$uno = $res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}
	function listaCompra() {
		$sql = "SELECT * FROM vw_compra_lista";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function listaCompraIde($compra) {
		$sql = "SELECT * FROM vw_compra_lista WHERE compra_ide = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$compra);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function listaCompraDeta($compra) {
		$sql = "SELECT * FROM vw_compra_lista_deta WHERE compra_ide = ? order by compra_ide";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$compra);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function compraAnular() { 
		$sql = "SELECT fn_compra(?,0,0,0,0,0,0,0,0,3,?) as compra";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->compra);
		$res->bindParam(2,$_SESSION['ced']);
		$res->execute();
		$result = $res->fetchAll(PDO::FETCH_OBJ);

		$row = $this->listaCompraDeta($this->compra);
		
		foreach($row as $r){
			$sql1 = "SELECT fn_compradeta(0,?,?,0,0,0,0,6,?) as compradeta";
			$res1 = $this->con->prepare($sql1);
			$res1->bindParam(1,$r->compra_ide);
			$res1->bindParam(2,$r->produc_ide);
			$res1->bindParam(3,$_SESSION['ced']);
			$res1->execute();
			$result1 = $res1->fetchAll(PDO::FETCH_OBJ);
		}
		if (($result[0]->compra == 1) && ($result1[0]->compradeta == 1)) {
			$rt=1;
		}else{
			$rt=0;
		}
		return $rt;
	}
} #class
?>