<?php 
	require '../../../cfg/base.php';
?>
<div id="calendar"></div>
<!-- PARA EVITAR CONFLICTOS ENTRE VERSIONES, SE CARGAN TANTO LOS ESTILOS COMO EL SCRIPT -->
<script>
//document.addEventListener('DOMContentLoaded', function() {
	var calendarEl = document.getElementById('calendar');

	var calendar = new FullCalendar.Calendar(calendarEl, {
		height: 'auto',
		contentHeight: 'auto',
		locale: 'es',
		//timeFormat:'h:mm A', // FORMATO DE HORA QUE SE VE EN EL CINTILLO DE EVENTO
		// FORMATO DE HORA PARA EL INTERVALO DE HORA
		slotLabelFormat: {
			hour:'2-digit',
			minute:'2-digit',
				meridiem:'short',
				hour12: true,
		},
		slotLabelInterval : '01:00', // FRECUENCIA CON LA QUE SE IMPRIME EL TEXTO DE INTERVALO DE HORAS
		//slotDuration : '01:00',
		//allDaySlot : true, // Ocultar - mostar espacio de "todo el dia"
		eventLimit: true, // colocar el (mas..) cuando hay muchos eventos
		navLinks: true, // deja seleccionar el dia (cambia la vista al dia selecccionado)
		selectable: true, // Permite al usuario resaltar varios días o intervalos de tiempo haciendo clic y arrastrando.
		selectMirror: true, // Resaltar mientras el usuario arrastra o selecciona
		// selectOverlap: false, // Impide seleccionar lapso de tiempo donde ya hay un evento creado
		views: {
				week: {
					titleFormat: { month: 'long', year: 'numeric', day:'numeric'},
				},
				day: {
						titleFormat: { weekday: 'long', year: 'numeric', day:'numeric'} 
				}
		},
		plugins: [ 'dayGrid', 'timeGrid', 'interaction','momentPlugin','timeGridWeek' ],
		defaultView: 'timeGridWeek',
		header: {
			left: 'prev,next',
			center: 'title',
			right: 'dayGridMonth,timeGridWeek,timeGridDay'
		},
		minTime: '05:00',
		maxTime: '22:00',
		businessHours: {
			daysOfWeek: [0,6], // resaltar todos los dias menos sabado y domingo, puede funcionar para desactivar dias ocupados?
			startTime: '05:00', // desde
			endTime: '22:00', // hasta
		},
		events: function(info, successCallback, failureCallback)  {
			$.ajax({
				method:'POST',
				cache: false,
				url: 'app/citas/procesos/p.precitas.mostrar.php',
				data: {},
				dataType: 'json',
				success: function(data) {
					var events = [];
					data.forEach(arr => {
						titulo = '- Lugar: '+arr.citas_lugar+'\n - Observación: '+arr.citas_obser;
						events.push({
							ide : arr.citas_ide,
							title: titulo,
							start: arr.citas_hen,
							end : arr.citas_hsa,
							allDay: false,
							overlap:true,
							editable: true,
							startEditable:true, // no permitir aditar arrastrando el evento
							backgroundColor: arr.citas_color,
							// LAS TIPO 0 Y 1 PROVIENEN DE LA TABLA CITAS
							extendedProps: {
								tipo: arr.citas_tipo,
								cita_clinica: arr.citas_clinica,
								cita_odonto: arr.citas_odonto,
							},
							fechaCita: arr.citas_fecha
						});
					});
					successCallback(events);
				},
				error: function(xhr){
					failureCallback(xhr);
				}
			});
		},
		eventClick: function(info) {
			inicio = moment(info.event.start).format();
			fin = moment(info.event.end).format();
			event_ide = info.event._def.extendedProps.ide;
			datos = 'inicio='+inicio+'&fin='+fin+'&allDay='+info.event.allDay+'&event_ide='+event_ide;
			modal('app/citas/vistas/editar.evento.preagenda.php',datos);
		}
	});
  calendar.render();
//});
</script>