<?php 
	require '../../../cfg/base.php';
	$data_cita = $mcitas->citaPorIde($event_ide);
	$odontologo = $musuarios->datosOdontologo($odonto);
	$clinicas = $mhorario->clinicaOdonto($odonto);
	$clientes_rows = $musuarios->getAll();
	$especialidades = $mespecialidad->especSelect();

	$date_inicio = explode('T', $inicio);
	$date_fin = explode('T', $fin);

	$f_ini = $date_inicio[0];
	$f_fin = $date_fin[0];
	$hora_ini = $date_inicio[1];
	$hora_fin = $date_fin[1];

	$hora_ini = explode('-', $hora_ini);
	$hora_fin = explode('-', $hora_fin);

	/*echo $odonto.' - '.$clinica.' - '.$inicio.' - '.$fin.' - '.$allDay;
	echo "\n";
	echo $f_ini.' - '.$f_fin.' - '.$hora_ini[0].' - '.$hora_fin[0];*/

?>
<style>
	.addPaciente :hover{
		cursor: pointer;
	}

	.addPaciente{
		background-color: #428bca !important;
		border-color: #428bca !important;
	}

	.addPaciente i{
		color:#FFFF;
	}

	.btn-colorpicker{
		width: 305px !important;
	}

</style>
<?php echo $fun->modalWidth('75') ?>
<?php echo $fun->modalHeader('Agregar Cita o Evento') ?>
<div class="modal-body">
	<div class="bootbox-body">
		<div class="col-lg-12 col-sm-12">

			<div class="mensaje1"></div>

			<form action="" class="citas-update" role="form">

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Odontol&oacute;go:</label>
					<div class="col-lg-8 col-sm-12">
						<input readonly type="text" class="form-control" name="odontologo" value="<?php echo $data_cita[0]->odontologo ?>">
					</div>
				</div>

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Tipo de Evento:</label>
					<div class="col-lg-8 col-sm-12">
						<select name="tipo" class="select_tipo" id="select_tipo">
							<option value=""></option>
							<option value="0" <?php echo $fun->selected($data_cita[0]->citas_tipo,0) ?>>CITA DE PACIENTES</option>
							<option value="1" <?php echo $fun->selected($data_cita[0]->citas_tipo,1) ?>>EVENTO</option>
						</select>
					</div>
				</div>

				<div class="clearfix"></div>

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Fecha Inicio:</label>
					<div class="col-lg-8 col-sm-12">
						<input readonly type="text" class="form-control" name="diainicio" value="<?php echo date('d-M-Y',strtotime($f_ini)) ?>">
					</div>
				</div>

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Fecha Final:</label>
					<div class="col-lg-8 col-sm-12">
						<input readonly type="text" class="form-control" name="diafin" value="<?php echo date('d-M-Y',strtotime($f_fin)) ?>">
					</div>
				</div>
				
				<div class="clearfix"></div>

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Hora inicio:</label>
					<div class="col-lg-8 col-sm-12">
						<input readonly type="text" class="form-control" id="hora_ent" value="<?php echo $hora_ini[0] ?>">
					</div>
				</div>

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Hora Final:</label>
					<div class="col-lg-8 col-sm-12">
						<input readonly type="text" class="form-control" id="hora_sal" value="<?php echo $hora_fin[0] ?>">
					</div>
				</div>

				<div class="clearfix"></div>

				<div class="form-group row col-lg-6 clinicas">
					
				</div>
				
				<div class="form-group row col-lg-6 pacientes">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Paciente:</label>
					<div class="col-lg-8 col-sm-12 input-group">
						<select name="paciente" class="select_paciente" id="select_paciente">
							<option value=""></option>
							<?php foreach($clientes_rows as $r) : ?>
								<option value="<?php echo $r->pacien_cedrif ?>" <?php echo $fun->selected($data_cita[0]->citas_per,$r->pacien_cedrif ) ?>><?php echo $r->pacien_nomraz.' - '. $r->pacien_nro_histo.' - '.$r->pacien_cedrif ?></option>
							<?php endforeach; ?>
						</select>
					</div>
				</div>

				<div class="form-group row col-lg-6 etiquetas">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Tipo de consulta:</label>
					<div class="col-lg-8 col-sm-12">
						<select name="etiqueta" id="etiqueta" class="col-sm-12 select_eti">
							<option value="">Seleccionar</option>
							<?php if (!empty($especialidades)) {
								foreach ($especialidades as $especialidad) {
									$selected = ($especialidad->espec_ide == $data_cita[0]->citas_eti) ? 'selected' : '';
								?>
									<option value="<?php echo $especialidad->espec_ide; ?>" <?php echo $selected; ?> ><?php echo $especialidad->espec_descrip; ?></option>
								<?php }
							}
							?>
						</select>
					</div>
				</div>

				<div class="form-group row col-lg-6 sillas">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Unidad:</label>
					<div class="col-lg-8 col-sm-12">
						<select name="silla" id="silla" class="col-sm-12 select_silla">
							<option value="1" <?php echo $fun->selected($data_cita[0]->citas_silla,1) ?>>1</option>
							<option value="2" <?php echo $fun->selected($data_cita[0]->citas_silla,2) ?>>2</option>
							<option value="3" <?php echo $fun->selected($data_cita[0]->citas_silla,3) ?>>3</option>
						</select>
					</div>
				</div>

				<div class="form-group row col-lg-6 observaciones">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Observación:</label>
					<div class="col-lg-8 col-sm-12">
						<input type="text" name="obser" id="obser" class="form-control col-sm-12" maxlength="255" value="<?php echo $data_cita[0]->citas_obser ?>">
					</div>
				</div>

				<div class="form-group row col-lg-6 direccion">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Dirección:</label>
					<div class="col-lg-8 col-sm-12">
						<input type="text" name="lugar" id="lugar" class="form-control col-sm-12" maxlength="255" value="<?php echo $data_cita[0]->citas_lugar ?>">
					</div>
				</div>

				<div class="form-group row col-lg-6 colores">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Color de evento:</label>
					<div class="col-lg-8 col-sm-12" title="Clic para cambiar el color">
						<select id="color" name="color" class="hide">
							<option value="#AC725E" <?php echo $fun->selected($data_cita[0]->citas_color,'#AC725E') ?>>#AC725E</option>
							<option value="#D06B64" <?php echo $fun->selected($data_cita[0]->citas_color,'#D06B64') ?>>#D06B64</option>
							<option value="#F83A22" <?php echo $fun->selected($data_cita[0]->citas_color,'#F83A22') ?>>#F83A22</option>
							<option value="#FA573C" <?php echo $fun->selected($data_cita[0]->citas_color,'#FA573C') ?>>#FA573C</option>
							<option value="#FF7537" <?php echo $fun->selected($data_cita[0]->citas_color,'#FF7537') ?>>#FF7537</option>
							<option value="#FFAD46" <?php echo $fun->selected($data_cita[0]->citas_color,'#FFAD46') ?>>#FFAD46</option>
							<option value="#42D692" <?php echo $fun->selected($data_cita[0]->citas_color,'#42D692') ?>>#42D692</option>
							<option value="#16A765" <?php echo $fun->selected($data_cita[0]->citas_color,'#16A765') ?>>#16A765</option>
							<option value="#7BD148" <?php echo $fun->selected($data_cita[0]->citas_color,'#7BD148') ?>>#7BD148</option>
							<option value="#B3DC6C" <?php echo $fun->selected($data_cita[0]->citas_color,'#B3DC6C') ?>>#B3DC6C</option>
							<option value="#FBE983" <?php echo $fun->selected($data_cita[0]->citas_color,'#FBE983') ?>>#FBE983</option>
							<option value="#FAD165" <?php echo $fun->selected($data_cita[0]->citas_color,'#FAD165') ?>>#FAD165</option>
							<option value="#92E1C0" <?php echo $fun->selected($data_cita[0]->citas_color,'#92E1C0') ?>>#92E1C0</option>
							<option value="#9FE1E7" <?php echo $fun->selected($data_cita[0]->citas_color,'#9FE1E7') ?>>#9FE1E7</option>
							<option value="#9FC6E7" <?php echo $fun->selected($data_cita[0]->citas_color,'#9FC6E7') ?>>#9FC6E7</option>
							<option value="#4986E7" <?php echo $fun->selected($data_cita[0]->citas_color,'#4986E7') ?>>#4986E7</option>
							<option value="#9A9CFF" <?php echo $fun->selected($data_cita[0]->citas_color,'#9A9CFF') ?>>#9A9CFF</option>
							<option value="#B99AFF" <?php echo $fun->selected($data_cita[0]->citas_color,'#B99AFF') ?>>#B99AFF</option>
							<option value="#C2C2C2" <?php echo $fun->selected($data_cita[0]->citas_color,'#C2C2C2') ?>>#C2C2C2</option>
							<option value="#CABDBF" <?php echo $fun->selected($data_cita[0]->citas_color,'#CABDBF') ?>>#CABDBF</option>
							<option value="#CCA6AC" <?php echo $fun->selected($data_cita[0]->citas_color,'#CCA6AC') ?>>#CCA6AC</option>
							<option value="#F691B2" <?php echo $fun->selected($data_cita[0]->citas_color,'#F691B2') ?>>#F691B2</option>
							<option value="#CD74E6" <?php echo $fun->selected($data_cita[0]->citas_color,'#CD74E6') ?>>#CD74E6</option>
							<option value="#A47AE2" <?php echo $fun->selected($data_cita[0]->citas_color,'#A47AE2') ?>>#A47AE2</option>
							<option value="#555" <?php echo $fun->selected($data_cita[0]->citas_color,'#555') ?>>#555</option>
						</select>
					</div>
				</div>

				<input type="hidden" name="hor_ent" value="<?php echo $inicio ?>">
				<input type="hidden" name="hor_sal" value="<?php echo $fin ?>">
				<input type="hidden" name="allDay" value="<?php echo $allDay ?>">
				<input type="hidden" name="odonto" id="odonto" value="<?php echo $odonto ?>">
				<input type="hidden" name="event_ide" id="event_ide" value="<?php echo $event_ide ?>">
				
			</form>
		</div>
	</div>
</div>
<div class="clearfix"></div>

<div class="modal-footer">
	<button class="btn btn-default cerrarmodal" data-dismiss="modal" type="button" data-bb-handler="cancel">Cancelar</button>
	<button class="btn btn-default btn-danger" id="deleteEvent">Borrar</button>
	<button class="btn btn-primary btn-modificar" type="button" data-bb-handler="confirm">Guardar Cambios</button>
</div>
<?php //echo $fun->modalFooter('Guardar Cambios','btn-modificar') ?>
<script>

	$(document).ready(function() {

		$('#color').ace_colorpicker();

		$('.btn-modificar').click(function() {
			$('.citas-update').submit();
		});
		
		$('.select_paciente').chosen({
			no_results_text: 'No hay coincidencias',
			width: '100%'
		});
		
		$('.select_eti').chosen({
			no_results_text: 'No hay coincidencias',
			width: '100%'
		});
		
		$('.select_silla').chosen({
			no_results_text: 'No hay coincidencias',
			width: '100%'
		});
		
		$('.select_tipo').chosen({
			no_results_text: 'No hay coincidencias',
			width: '100%'
		}).change(function() {
			if ($(this).val() != '') {
				if ($(this).val() == 0) {
					$('.pacientes').fadeIn(300,'swing');
					$('.etiquetas').fadeIn(300,'swing');
					$('.sillas').fadeIn(300,'swing');
					$('.colores').fadeIn(300,'swing');
					$('.observaciones').fadeIn(300,'swing');
					$('.clinicas').fadeIn(300,'swing');
					$('.direccion').fadeOut(300,'swing');
					valClinica($(this).val());
				}else{
					$('.pacientes').fadeOut(300,'swing');
					$('.etiquetas').fadeOut(300,'swing');
					$('.sillas').fadeOut(300,'swing');
					$('.colores').fadeIn(300,'swing');
					$('.observaciones').fadeIn(300,'swing');
					$('.clinicas').fadeOut(300,'swing');
					$('.direccion').fadeIn(300,'swing');
					// CAMBIA A 0 LA CLINICA YA QUE NO ES UNA CITA DE PACIENTE
					valClinica($(this).val());
				}
			}
		});

		if ($('#select_tipo').val() == 0) {
			$('.pacientes').fadeIn(300,'swing');
			$('.etiquetas').fadeIn(300,'swing');
			$('.sillas').fadeIn(300,'swing');
			$('.colores').fadeIn(300,'swing');
			$('.observaciones').fadeIn(300,'swing');
			$('.clinicas').fadeIn(300,'swing');
			$('.direccion').fadeOut(300,'swing');
			valClinica($(this).val());
		}else{
			$('.pacientes').fadeOut(300,'swing');
			$('.etiquetas').fadeOut(300,'swing');
			$('.sillas').fadeOut(300,'swing');
			$('.colores').fadeIn(300,'swing');
			$('.observaciones').fadeIn(300,'swing');
			$('.clinicas').fadeOut(300,'swing');
			$('.direccion').fadeIn(300,'swing');
			// CAMBIA A 0 LA CLINICA YA QUE NO ES UNA CITA DE PACIENTE
			valClinica($(this).val());
		}
	});

	$('#addPaciente').click(function() {
		console.log('entrando')
	});

	function valClinica(tipocita){
		if (tipocita == 0) {
			clinicas();
		}else{
			// LA CLINICA ES 0 PORQUE NO ES CITA DE PACIENTE
			input = '<input type="hidden" name="clinica" value="0" id="clinica">';
			$('.citas-update').append(input);
		}
	}

	function select_clinica(){	
		$('.select_clinica').chosen({
			no_results_text: 'No hay coincidencias',
			width: '100%'
		});
	}

	function clinicas(){
		clinicaid = '<?php echo $data_cita[0]->citas_clinica ?>';
		odonto = $('#odonto').val();
		html = '';
		if (clinicaid != 0) {
			disabled = 'disabled';
			clinica = clinicaid;
			html = '<input type="hidden" name="clinica" value="'+clinica+'" id="clinica">';
			$.post('app/citas/procesos/p.lista.clinicas.php','clinica='+clinica+'&odonto='+odonto+'&opt=0',function(data){
				data = JSON.parse(data);
				html += '<label for="" class="control-label col-lg-4 col-sm-12 bolder">Cl&iacute;nica:</label>'+
						'<div class="col-lg-8 col-sm-12">'+
							'<select name="clinica" id="clinica" class="select_clinica" data-placeholder="Seleccione una Clinica">'+
								'<option selected value="'+data[0].clinica_ide+'">'+data[0].clinica_descripcion+'</option>'+
							'</select>'+
						'</div>';

				$('.clinicas').html(html);
				select_clinica();
			});
		}else{
			disabled = '';
			clinica = '';
			$.post('app/citas/procesos/p.lista.clinicas.php','clinica='+clinica+'&odonto='+odonto+'&opt=1',function(data){
				data = JSON.parse(data);
				html = '<label for="" class="control-label col-lg-4 col-sm-12 bolder">Cl&iacute;nica:</label>'+
						'<div class="col-lg-8 col-sm-12">'+
							'<select '+disabled+' name="clinica" id="clinica" class="select_clinica" data-placeholder="Seleccione una Clinica">'+
								'<option value=""></option>';
								$.each(data,function(i,item){
									html += '<option value="'+data[i].clinicmed_clinic+'">'+data[i].clinica_descripcion+'</option>';
								})
				html +=		'</select>'+
						'</div>';

				$('.clinicas').html(html);
				select_clinica()
			});
		}
	}

	$(function(){
		$('.citas-update').validate({
			errorElement: 'div',
			errorClass: 'help-inline',
			focusInvalid: true,
			rules: {
				num_iden: {
					required: true,
					number: true,
				},
			},
			messages: {
				num_iden: {
					required: 'Obligatorio',
					number: 'Ingrese solo numeros'
				},
			},
			invalidHandler: function (event, validator) { 
				$('.alert-danger', $('.citas-update')).show();
			},			
			highlight: function (e) {
				$(e).closest('.form-group').removeClass('has-info').addClass('has-error');
			},
			success: function (e) {
				$(e).closest('.form-group').removeClass('has-error').addClass('has-info');
				$(e).remove();
			},
			submitHandler: function (form) {
				tipo = $('.select_tipo').val();

				paciente = $('.select_paciente').val();
				etiqueta = $('#etiqueta').val();
				clinica = $('#clinica').val();
				odonto = $('#odonto').val();
				color = $('#color').val();

				if (tipo != '') {
					if (tipo == 0) {
						// CITA CON PACIENTE
						if ((clinica != '') && (paciente != '') && (color != '')) {
							$.post('app/citas/procesos/p.cita.update.php',$('.citas-update').serialize(),function(data){
								if (!isNaN(data)) {
									alert('Registro modificado con exito.');
									load('app/citas/vistas/agendaMedicos.php','odonto='+odonto+'&clinica=<?php echo $clinica ?>','#calendar');
									cerrarmodal();
								}else{
									alerta('.mensaje1','danger',data);
								}
							})
						}else{
							alerta('.mensaje1','danger','Los campos clinica, paciente, tipo de consulta y color son obligatorios');
						}
					}else{
						// CITA TIPO EVENTO
						if (color != '') {
							$.post('app/citas/procesos/p.cita.update.php',$('.citas-update').serialize(),function(data){
								if (!isNaN(data)) {
									alert('Registro modificado con exito.');
									load('app/citas/vistas/agendaMedicos.php','odonto='+odonto+'&clinica=<?php echo $clinica ?>','#calendar');
									cerrarmodal();
								}else{
									alerta('.mensaje1','danger',data);
								}
							})
						}else{
							alerta('.mensaje1','danger','Los campos clinica, paciente, tipo de consulta y color son obligatorios');
						}
					}
				}else{
					alerta('.mensaje1','danger','Seleccione el tipo de evento');
				}
			},
			invalidHandler: function (form) {
			}
		})
	});

	$('#deleteEvent').click(function(){
		event_ide = $('#event_ide').val();
		if (confirm('Desea borrar el evento seleccionado?')) {
			$.post('app/citas/procesos/p.citas.delete.php','citas_ide='+event_ide,function(data){
				if (!isNaN(data)) {
					load('app/citas/vistas/agendaMedicos.php','odonto='+odonto+'&clinica=<?php echo $clinica ?>','#calendar');
					alert('Registro borrado correctamente');
					cerrarmodal();
				}else{
					alerta('.mensaje1','danger',data);
				}
			})
		}
	})

</script>