<?php 
	require'../../../cfg/base.php';
	$odontologo = $musuarios->datosOdontologo($odonto);
	$clinicas = $mhorario->clinicaOdonto($odonto);
	$clientes_rows = $musuarios->getAll();
	$especialidades = $mespecialidad->especSelect();

	$date_inicio = explode('T', $inicio);
	$date_fin = explode('T', $fin);

	$f_ini = $date_inicio[0];
	$f_fin = $date_fin[0];
	$hora_ini = $date_inicio[1];
	$hora_fin = $date_fin[1];

	$hora_ini = explode('-', $hora_ini);
	$hora_fin = explode('-', $hora_fin);

	/*echo $odonto.' - '.$clinica.' - '.$inicio.' - '.$fin.' - '.$allDay;
	echo "\n";
	echo $f_ini.' - '.$f_fin.' - '.$hora_ini[0].' - '.$hora_fin[0];*/

?>
<style>
	.addPaciente :hover{
		cursor: pointer;
	}

	.addPaciente{
		background-color: #428bca !important;
		border-color: #428bca !important;
	}

	.addPaciente i{
		color:#FFFF;
	}

	.btn-colorpicker{
		width: 305px !important;
	}
	select {
		height: auto !important;
	}
</style>
<?php echo $fun->modalWidth('75') ?>
<?php echo $fun->modalHeader('Agregar Cita o Evento') ?>
<div class="modal-body">
	<div class="bootbox-body">
		<div class="col-lg-12 col-sm-12">

			<div class="mensaje1"></div>

			<form action="" class="citas-insert" role="form">

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Odontol&oacute;go:</label>
					<div class="col-lg-8 col-sm-12">
						<input readonly type="text" class="form-control" name="odontologo" value="<?php echo $odontologo[0]->pacien_nomraz ?>">
					</div>
				</div>

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Tipo de Evento:</label>
					<div class="col-lg-8 col-sm-12">
						<select name="tipo" class="select_tipo" id="select_tipo">
							<option value="">Seleccionar</option>
							<option value="0">CITA DE PACIENTES</option>
							<option value="1">EVENTO</option>
						</select>
					</div>
				</div>

				<div class="clearfix"></div>

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Fecha Inicio:</label>
					<div class="col-lg-8 col-sm-12">
						<input readonly type="text" class="form-control" name="diainicio" value="<?php echo date('d-M-Y',strtotime($f_ini)) ?>">
					</div>
				</div>

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Fecha Final:</label>
					<div class="col-lg-8 col-sm-12">
						<input readonly type="text" class="form-control" name="diafin" value="<?php echo date('d-M-Y',strtotime($f_fin)) ?>">
					</div>
				</div>
				
				<div class="clearfix"></div>

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Hora inicio:</label>
					<div class="col-lg-8 col-sm-12">
						<input readonly type="text" class="form-control" id="hora_ent" value="<?php echo $hora_ini[0] ?>">
					</div>
				</div>

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Hora Final:</label>
					<div class="col-lg-8 col-sm-12">
						<input readonly type="text" class="form-control" id="hora_sal" value="<?php echo $hora_fin[0] ?>">
					</div>
				</div>

				<div class="clearfix"></div>

				<div class="form-group row col-lg-6 clinicas">
					
				</div>
				
				<div class="form-group row col-lg-6 pacientes">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Paciente:</label>
					<div class="col-lg-8 col-sm-12 input-group">
						<select name="paciente" class="select_paciente chosen" id="select_paciente">
							<option value="">Seleccionar</option>
							<?php foreach($clientes_rows as $r) : ?>
								<option data-paciente="<?php echo htmlspecialchars(json_encode($r), ENT_QUOTES) ?>" value="<?php echo $r->pacien_cedrif ?>"><?php echo $r->pacien_nomraz.' - '. $r->pacien_nro_histo.' - '.$r->pacien_cedrif ?></option>
							<?php endforeach; ?>
						</select>
					</div>
				</div>

				<div class="form-group row col-lg-6 pacientes">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Nro Identificación:</label>
					<div class="col-lg-8 col-sm-12 input-group" style="display: flex;">
						<?php echo $fun->nacionalidad(-1); ?>
						<input type="text" class="form-control" name="cedrif" id="cedrif" value="">
					</div>
				</div>

				<div class="form-group row col-lg-6 pacientes">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Nombres y Apellidos:</label>
					<div class="col-lg-8 col-sm-12 input-group">
						<input type="text" class="form-control" name="nomraz" id="nomraz" value="">
					</div>
				</div>

				<div class="form-group row col-lg-6 pacientes">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Telefono:</label>
					<div class="col-lg-8 col-sm-12 input-group">
						<input type="text" name="telefono" id="telefono" class="form-control" value="">
					</div>
				</div>

				<div class="form-group row col-lg-6 etiquetas">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Tipo de consulta:</label>
					<div class="col-lg-8 col-sm-12">
						<select name="etiqueta" id="etiqueta" class="col-sm-12 select_eti">
							<option value="">Seleccionar</option>
							<?php if (!empty($especialidades)) {
								foreach ($especialidades as $especialidad) { ?>
									<option value="<?php echo $especialidad->espec_ide; ?>"><?php echo $especialidad->espec_descrip; ?></option>
								<?php }
							}
							?>
						</select>
					</div>
				</div>

				<div class="form-group row col-lg-6 sillas">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Unidad:</label>
					<div class="col-lg-8 col-sm-12">
						<select name="silla" id="silla" class="col-sm-12 select_silla">
							<option value="1">1</option>
							<option value="2">2</option>
							<option value="3">3</option>
						</select>
					</div>
				</div>

				<div class="form-group row col-lg-6 observaciones">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Observación:</label>
					<div class="col-lg-8 col-sm-12">
						<input type="text" name="obser" id="obser" class="form-control col-sm-12" maxlength="255">
					</div>
				</div>

				<div class="form-group row col-lg-6 direccion">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Lugar:</label>
					<div class="col-lg-8 col-sm-12">
						<input type="text" name="lugar" id="lugar" class="form-control col-sm-12" maxlength="255">
					</div>
				</div>

				<div class="form-group row col-lg-6 colores">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Color de evento:</label>
					<div class="col-lg-8 col-sm-12" title="Clic para cambiar el color">
						<select id="color" name="color" class="hide">
							<option value="#ac725e" selected="selected">#ac725e</option>
							<option value="#d06b64">#d06b64</option>
							<option value="#f83a22">#f83a22</option>
							<option value="#fa573c">#fa573c</option>
							<option value="#ff7537">#ff7537</option>
							<option value="#ffad46">#ffad46</option>
							<option value="#42d692">#42d692</option>
							<option value="#16a765">#16a765</option>
							<option value="#7bd148">#7bd148</option>
							<option value="#b3dc6c">#b3dc6c</option>
							<option value="#fbe983">#fbe983</option>
							<option value="#fad165">#fad165</option>
							<option value="#92e1c0">#92e1c0</option>
							<option value="#9fe1e7">#9fe1e7</option>
							<option value="#9fc6e7">#9fc6e7</option>
							<option value="#4986e7">#4986e7</option>
							<option value="#9a9cff">#9a9cff</option>
							<option value="#b99aff">#b99aff</option>
							<option value="#c2c2c2">#c2c2c2</option>
							<option value="#cabdbf">#cabdbf</option>
							<option value="#cca6ac">#cca6ac</option>
							<option value="#f691b2">#f691b2</option>
							<option value="#cd74e6">#cd74e6</option>
							<option value="#a47ae2">#a47ae2</option>
							<option value="#555">#555</option>
						</select>
					</div>
				</div>

				<input type="hidden" name="hor_ent" value="<?php echo $inicio ?>">
				<input type="hidden" name="hor_sal" value="<?php echo $fin ?>">
				<input type="hidden" name="allDay" value="<?php echo $allDay ?>">
				<input type="hidden" name="odonto" id="odonto" value="<?php echo $odonto ?>">

			</form>
		</div>
	</div>
</div>
<div class="clearfix"></div>
<?php echo $fun->modalFooter('Guardar Cambios','btn-modificar') ?>
<script>
	$(document).ready(function() {
		clinicas();

		$('#color').ace_colorpicker();

		$('.pacientes').fadeOut(1);
		$('.etiquetas').fadeOut(1);
		$('.sillas').fadeOut(1);
		$('.colores').fadeOut(1);
		$('.observaciones').fadeOut(1);
		$('.direccion').fadeOut(1);
		$('.clinicas').fadeOut(1);

		$('.btn-modificar').click(function() {
			$('.citas-insert').submit();
		});
		
		$('.select_paciente').chosen({
			no_results_text: 'No hay coincidencias',
			width: '100%'
		});

		$('.select_paciente').on('change', function () {
			$('#cedrif').val('').attr('readonly', false);
			$('#nomraz').val('').attr('readonly', false);
			$('#telefono').val('').attr('readonly', false);
			$('#nac').val('').attr('readonly', false);
			if ($(this).val()) {
				const dataPaciente = $(this).find(':selected').data('paciente');
				$('#cedrif').val(dataPaciente.pacien_cedrif).attr('readonly', true);
				$('#nomraz').val(dataPaciente.pacien_nomraz).attr('readonly', true);
				$('#telefono').val(dataPaciente.pacien_movil1tlf).attr('readonly', true);
				$('#nac').val(dataPaciente.pacien_nac);
			}
		})
		
		$('.select_eti').chosen({
			no_results_text: 'No hay coincidencias',
			width: '100%'
		});
		
		$('.select_silla').chosen({
			no_results_text: 'No hay coincidencias',
			width: '100%'
		});
		
		$('.select_tipo').chosen({
			no_results_text: 'No hay coincidencias',
			width: '100%'
		}).change(function() {
			if ($(this).val() != '') {
				if ($(this).val() == 0) {
					$('.pacientes').fadeIn(300,'swing');
					$('.etiquetas').fadeIn(300,'swing');
					$('.sillas').fadeIn(300,'swing');
					$('.colores').fadeIn(300,'swing');
					$('.observaciones').fadeIn(300,'swing');
					$('.clinicas').fadeIn(300,'swing');
					$('.direccion').fadeOut(300,'swing');
					valClinica($(this).val());
				}else{
					$('.pacientes').fadeOut(300,'swing');
					$('.etiquetas').fadeOut(300,'swing');
					$('.sillas').fadeOut(300,'swing');
					$('.colores').fadeIn(300,'swing');
					$('.observaciones').fadeIn(300,'swing');
					$('.clinicas').fadeOut(300,'swing');
					$('.direccion').fadeIn(300,'swing');
					// CAMBIA A 0 LA CLINICA YA QUE NO ES UNA CITA DE PACIENTE
					valClinica($(this).val());
				}
			}
		});
	});

	$('#addPaciente').click(function() {
		//console.log('entrando')
	});

	function valClinica(tipocita){
		if (tipocita == 0) {
			clinicas();
		}else{
			// LA CLINICA ES 0 PORQUE NO ES CITA DE PACIENTE
			input = '<input type="hidden" name="clinica" value="0" id="clinica">';
			$('.citas-insert').append(input);
		}
	}

	function select_clinica(){	
		$('.select_clinica').chosen({
			no_results_text: 'No hay coincidencias',
			width: '100%'
		});
	}

	function clinicas(){
		clinicaid = '<?php echo $clinica ?>';
		odonto = $('#odonto').val();
		html = '';
		if (clinicaid != '%') {
			clinica = clinicaid;
			html = '<input type="hidden" name="clinica" value="'+clinica+'" id="clinica">';
			$.post('app/citas/procesos/p.lista.clinicas.php','clinica='+clinica+'&odonto='+odonto+'&opt=0',function(data){
				data = JSON.parse(data);
				html += '<label for="" class="control-label col-lg-4 col-sm-12 bolder">Cl&iacute;nica:</label>'+
						'<div class="col-lg-8 col-sm-12">'+
							'<select name="clinica" id="clinica" class="select_clinica" data-placeholder="Seleccione una Clinica">'+
								'<option selected value="'+data[0].clinica_ide+'">'+data[0].clinica_descripcion+'</option>'+
							'</select>'+
						'</div>';

				$('.clinicas').html(html);
				select_clinica();
			});
		}else{
			clinica = '';
			$.post('app/citas/procesos/p.lista.clinicas.php','clinica='+clinica+'&odonto='+odonto+'&opt=1',function(data){
				data = JSON.parse(data);
				html = '<label for="" class="control-label col-lg-4 col-sm-12 bolder">Cl&iacute;nica:</label>'+
						'<div class="col-lg-8 col-sm-12">'+
							'<select name="clinica" id="clinica" class="select_clinica" data-placeholder="Seleccione una Clinica">'+
								'<option value=""></option>';
								$.each(data,function(i,item){
									html += '<option value="'+data[i].clinicmed_clinic+'">'+data[i].clinica_descripcion+'</option>';
								})
				html +=		'</select>'+
						'</div>';

				$('.clinicas').html(html);
				select_clinica()
			});
		}
	}

	$(function(){
		$('.citas-insert').validate({
			errorElement: 'div',
			errorClass: 'help-inline',
			focusInvalid: true,
			rules: {
				num_iden: {
					required: true,
					number: true,
				},
			},
			messages: {
				num_iden: {
					required: 'Obligatorio',
					number: 'Ingrese solo numeros'
				},
			},
			invalidHandler: function (event, validator) { 
				$('.alert-danger', $('.citas-insert')).show();
			},			
			highlight: function (e) {
				$(e).closest('.form-group').removeClass('has-info').addClass('has-error');
			},
			success: function (e) {
				$(e).closest('.form-group').removeClass('has-error').addClass('has-info');
				$(e).remove();
			},
			submitHandler: function (form) {
				const tipo = $('.select_tipo option:selected').val();

				const paciente = $('.select_paciente').val();
				const etiqueta = $('#etiqueta option:selected').val();
				const clinica = $('#clinica').val();
				const odonto = $('#odonto').val();
				const color = $('#color').val();
				const lugar = $('#lugar').val();

				if (!tipo) {
					alerta('.mensaje1','danger','Seleccione el tipo de evento');
					return false;
				}
				if (tipo == 0) {
					if (!paciente && (!$('#nac').val() || !$('#cedrif').val() || !$('#nomraz').val() || !$('#telefono').val())) {
						alerta('.mensaje1','danger','El Nro Identificación, Nombres y Apellidos y Telefono son obligatorios');
						return false;
					}
					// CITA CON PACIENTE
					if (!clinica || !color || !etiqueta) {
						alerta('.mensaje1','danger','Los campos clinica, tipo de consulta y color son obligatorios');
						return false;
					}
					$.post('app/citas/procesos/p.citas.insert.php',$('.citas-insert').serialize(),function(data){
						if (!isNaN(data)) {
								alert('Registro agregado con exito.');
								load('app/citas/vistas/agendaMedicos.php','odonto='+odonto+'&clinica=<?php echo $clinica ?>','#calendar');
								cerrarmodal();
						}else{
							alerta('.mensaje1','danger',data);
						}
					});
				}else{
					// CITA TIPO EVENTO
					if (!color || !lugar) {
						alerta('.mensaje1','danger','Los campos color y lugar son obligatorios');
						return false;
					}
					$.post('app/citas/procesos/p.citas.insert.php',$('.citas-insert').serialize(),function(data){
						if (!isNaN(data)) {
								alert('Registro agregado con exito.');
								load('app/citas/vistas/agendaMedicos.php','odonto='+odonto+'&clinica=<?php echo $clinica ?>','#calendar');
								cerrarmodal();
						}else{
							alerta('.mensaje1','danger',data);
						}
					});
				}
			},
			invalidHandler: function (form) {
			}
		})
	})
</script>