<?php 
	require '../../../cfg/base.php';
	$data_cita = $mcitas->citaPorIde($event_ide);
	$clientes_rows = $musuarios->getAll();
	$especialidades = $mespecialidad->especSelect();

	$date_inicio = explode('T', $inicio);
	$date_fin = explode('T', $fin);

	$f_ini = $date_inicio[0];
	$f_fin = $date_fin[0];
	$hora_ini = $date_inicio[1];
	$hora_fin = $date_fin[1];

	$hora_ini = explode('-', $hora_ini);
	$hora_fin = explode('-', $hora_fin);

	$paciente = array_values(array_filter($clientes_rows, function ($arr) use($data_cita) {
		return $arr->pacien_cedrif == $data_cita[0]->citas_per;
	}));
?>
<style>
	.btn-colorpicker{
		width: 305px !important;
	}

</style>
<?php echo $fun->modalWidth('75') ?>
<?php echo $fun->modalHeader('Asignar Pre Agenda') ?>
<div class="modal-body">
	<div class="bootbox-body">
		<div class="col-lg-12 col-sm-12">

			<div class="mensaje1"></div>

			<form action="" class="preagenda-update" role="form">
				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Tipo de Evento:</label>
					<div class="col-lg-8 col-sm-12">
						<input type="text" id="select_tipo" class="form-control" value="CITA DE PACIENTES" disabled>
					</div>
				</div>

				<div class="clearfix"></div>

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Fecha Inicio:</label>
					<div class="col-lg-8 col-sm-12">
						<input type="text" class="form-control" name="diainicio" value="<?php echo date('d-M-Y',strtotime($f_ini)) ?>" disabled>
					</div>
				</div>

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Fecha Final:</label>
					<div class="col-lg-8 col-sm-12">
						<input type="text" class="form-control" name="diafin" value="<?php echo date('d-M-Y',strtotime($f_fin)) ?>" disabled>
					</div>
				</div>

				<div class="clearfix"></div>

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Hora inicio:</label>
					<div class="col-lg-8 col-sm-12">
						<input type="text" class="form-control" id="hora_ent" value="<?php echo $hora_ini[0] ?>" disabled>
					</div>
				</div>

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Hora Final:</label>
					<div class="col-lg-8 col-sm-12">
						<input type="text" class="form-control" id="hora_sal" value="<?php echo $hora_fin[0] ?>" disabled>
					</div>
				</div>

				<div class="clearfix"></div>

				<div class="form-group row col-lg-6 pacientes">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Paciente:</label>
					<div class="col-lg-8 col-sm-12">
						<input type="text" name="paciente" class="form-control" value="<?php echo $paciente[0]->pacien_nomraz.' - '. $paciente[0]->pacien_nro_histo.' - '.$paciente[0]->pacien_cedrif ?>" disabled>
					</div>
				</div>

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Especialidad *:</label>
					<div class="col-lg-8 col-sm-12">
						<select name="especialidad" id="especialidad" class="form-control select_eti">
							<option value="">Seleccionar</option>
							<?php if (!empty($especialidades)) {
								foreach ($especialidades as $especialidad) { ?>
									<option value="<?php echo $especialidad->espec_ide; ?>" ><?php echo $especialidad->espec_descrip; ?></option>
								<?php }
							}
							?>
						</select>
					</div>
				</div>

				<div class="clearfix"></div>

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Odontológo *:</label>
					<div class="col-lg-8 col-sm-12 odontologos">
						<select name="odontologo" id="odontologo" class="form-control">
							<option value="">Seleccionar</option>
						</select>
					</div>
				</div>

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Clínica *:</label>
					<div class="col-lg-8 col-sm-12 clinicas">
						<select name="clinica" id="clinica" class="form-control">
							<option value="">Seleccionar</option>
						</select>
					</div>
				</div>

				<div class="clearfix"></div>

				<div class="form-group row col-lg-6 sillas">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Unidad:</label>
					<div class="col-lg-8 col-sm-12">
						<select name="silla" id="silla" class="form-control select_silla">
							<option value="1" <?php echo $fun->selected($data_cita[0]->citas_silla,1) ?>>1</option>
							<option value="2" <?php echo $fun->selected($data_cita[0]->citas_silla,2) ?>>2</option>
							<option value="3" <?php echo $fun->selected($data_cita[0]->citas_silla,3) ?>>3</option>
						</select>
					</div>
				</div>

				<div class="form-group row col-lg-6 colores">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Color de evento *:</label>
					<div class="col-lg-8 col-sm-12" title="Clic para cambiar el color">
						<select id="color" name="color" class="form-control hide">
							<option value="#ac725e" selected="selected">#ac725e</option>
							<option value="#d06b64">#d06b64</option>
							<option value="#f83a22">#f83a22</option>
							<option value="#fa573c">#fa573c</option>
							<option value="#ff7537">#ff7537</option>
							<option value="#ffad46">#ffad46</option>
							<option value="#42d692">#42d692</option>
							<option value="#16a765">#16a765</option>
							<option value="#7bd148">#7bd148</option>
							<option value="#b3dc6c">#b3dc6c</option>
							<option value="#fbe983">#fbe983</option>
							<option value="#fad165">#fad165</option>
							<option value="#92e1c0">#92e1c0</option>
							<option value="#9fe1e7">#9fe1e7</option>
							<option value="#9fc6e7">#9fc6e7</option>
							<option value="#4986e7">#4986e7</option>
							<option value="#9a9cff">#9a9cff</option>
							<option value="#b99aff">#b99aff</option>
							<option value="#c2c2c2">#c2c2c2</option>
							<option value="#cabdbf">#cabdbf</option>
							<option value="#cca6ac">#cca6ac</option>
							<option value="#f691b2">#f691b2</option>
							<option value="#cd74e6">#cd74e6</option>
							<option value="#a47ae2">#a47ae2</option>
							<option value="#555">#555</option>
						</select>
					</div>
				</div>

				<div class="clearfix"></div>

				<div class="form-group row col-lg-6">
					<label for="" class="control-label col-lg-4 col-sm-12 bolder">Observación:</label>
					<div class="col-lg-8 col-sm-12">
						<textarea class="form-control" disabled><?php echo $data_cita[0]->citas_obser ?></textarea>
					</div>
				</div>
				<input type="hidden" name="event_ide" id="event_ide" value="<?php echo $event_ide ?>">
			</form>
		</div>
	</div>
</div>
<div class="clearfix"></div>

<div class="modal-footer">
	<button class="btn btn-default cerrarmodal" data-dismiss="modal" type="button" data-bb-handler="cancel">Cancelar</button>
	<button class="btn btn-primary btn-modificar" type="button" data-bb-handler="confirm">Asignar</button>
	<button class="btn btn-danger btn-rechazar" type="button" data-bb-handler="rechazar">Rechazar</button>
</div>
<script>

	$(document).ready(function() {

		$('#color').ace_colorpicker();

		$('.btn-modificar').click(function() {
			$('.preagenda-update').submit();
		});
		
		$('.select_eti').chosen({
			no_results_text: 'No hay coincidencias',
			width: '100%'
		});
		
		$('.select_silla').chosen({
			no_results_text: 'No hay coincidencias',
			width: '100%'
		});

		$('#odontologo').chosen({
			no_results_text: 'No hay coincidencias',
			width: '100%'
		});

		$('#especialidad').on('change', function () {
			const id = $(this).val();
			load('app/citas/procesos/p.dropdown.odontologo.php','especialidad_id='+id, '.odontologos');
		});

		$('.btn-rechazar').on('click', function () {
			const preagendaID = $('#event_ide').val();
			if (confirm('¿Desea rechazar esta pre agrenda?')) {
				$.post('app/citas/procesos/p.rechazar.preagenda.php','preagenda_id='+preagendaID,function(data){
					if (!isNaN(data)) {
						alert('Pre agenda rechazada con exito');
						load('app/citas/vistas/preagenda.php','','.calendar');
						cerrarmodal();
					}else{
						alerta('.msjerror','danger',data);
					}
				});
			}
		})
	});

	function select_clinica(){	
		$('.select_clinica').chosen({
			no_results_text: 'No hay coincidencias',
			width: '100%'
		});
	}

	$(function(){
		$('.preagenda-update').validate({
			errorElement: 'div',
			errorClass: 'help-inline',
			focusInvalid: true,
			rules: {
				especialidad: {
					required: true
				},
				odontologo: {
					required: true
				},
				clinica: {
					required: true
				},
				color: {
					required: true
				}
			},
			messages: {
				especialidad: {
					required: 'Obligatorio'
				},
				odontologo: {
					required: 'Obligatorio'
				},
				clinica: {
					required: 'Obligatorio'
				},
				color: {
					required: 'Obligatorio'
				}
			},
			invalidHandler: function (event, validator) { 
				$('.alert-danger', $('.preagenda-update')).show();
			},			
			highlight: function (e) {
				$(e).closest('.form-group').removeClass('has-info').addClass('has-error');
			},
			success: function (e) {
				$(e).closest('.form-group').removeClass('has-error').addClass('has-info');
				$(e).remove();
			},
			submitHandler: function (form) {
				especialidad = $('#especialidad').val();
				clinica = $('#clinica').val();
				odonto = $('#odontologo').val();
				color = $('#color').val();

				if (clinica && especialidad && odonto && color) {
					$.post('app/citas/procesos/p.confirmar.preagenda.php',$('.preagenda-update').serialize(),function(data){
						if (!isNaN(data)) {
							alert('Registro Asignado con exito.');
							load('app/citas/vistas/preagenda.php','','.calendar');
							cerrarmodal();
						}else{
							alerta('.mensaje1','danger',data);
						}
					})
				}else{
					alerta('.mensaje1','danger','Los campos clinica, especialidad, odontologo y color son obligatorios');
				}
			},
			invalidHandler: function (form) {
			}
		})
	});

</script>