<?php 
require '../../../cfg/base.php';
$clientes_rows = $musuarios->getAll();
?>
<?php echo $fun->modalHeader('Crear Nueva Cita') ?>
<script>
	$(function(){
		$(".uno").chosen({
			no_results_text: "No hay resultados",
			max_selected_options: 1
		});
		$('#validarCedula').validate({
			errorElement: 'div',
			errorClass: 'help-inline',
			focusInvalid: true,
			rules: {
				ced: {
					required: true,
					minlength: 7,
					number: true
				}
			},
			messages: {
				ced: {
					required: "Indique Nro Identificación",
					minlength: 'Número de Nro Identificación no válido',
					number: 'Debe indicar un valor numérico'
				}
			},
			invalidHandler: function (event, validator) { 
				$('.alert-danger', $('#validarCedula')).show();
			},			
			highlight: function (e) {
				$(e).closest('.form-group').removeClass('has-info').addClass('has-error');
			},
			success: function (e) {
				$(e).closest('.form-group').removeClass('has-error').addClass('has-info');
				$(e).remove();
			},
			submitHandler: function (form) {
				$.post('app/historia/procesos/p.cedula.buscar.php',$('.buscar-cedula').serialize(),function(data){
					if(data==1) {
						$.post('app/historia/procesos/p.cedula.existe.php',$('.buscar-cedula').serialize(),function(data2){
							if(data2==1) {
								load('app/citas/vistas/registrado.php',$('.buscar-cedula').serialize(),'#registro-cita');
							}  else {
								alerta('.msj_search','info','Por favor seleccione un valor de la lista, o haga click en el boton con el simbolo <i class="fa fa-plus"></i> para crear un nuevo registro');
								$('#registro-cita').html('')
							}
						})
					} else {
						alerta('.msj','danger',data);
						$('#registro-cita').html('')
					}
				})
			},
			invalidHandler: function (form) {
				$('#historia').fadeOut(1);
			}
		})
	})	
</script>
<div class="modal-body">
		<div class="msj_search"></div>
		<form action="" class="buscar-cedula col-sm-12" role="form" id="validarCedula">
<!--
			<div class="form-group">
				<label class="col-sm-2"><strong>Nro Identificación:</strong></label>
				<div class="col-sm-2">
					<select name="nac" id="nac" class="form-control">
						<option value="CC">CC</option>
						<option value="CE">CE</option>
						<option value="TI">TI</option>
					</select>
				</div>
				<div class="col-sm-7">
					<input autocomplete="off" id="cedrif" type="text" placeholder="Nro Identificación" name="ced" class="form-control">
				</div>
				<div class="col-sm-1">
					<button class="btn btn-primary btn-sm"><i class="fa fa-search"></i></button>
				</div>
			</div>
-->
			<div class="form-group">
				<label for="" class="control-label col-sm-12 bolder">Buscar</label>
				<div class="col-sm-8">
					<select id="cedrif" class="uno form-control col-sm-12" data-placeholder="Seleccione" multiple="" name="cedrif">
						<option value=""></option>
						<?php foreach($clientes_rows as $r) { ?>
							<option value="<?php echo $r->pacien_cedrif ?>"><?php echo $r->pacien_nomraz.' - '. $r->pacien_nro_histo.' - '.$r->pacien_cedrif ?></option>
						<?php } ?>
					</select>
				</div>
				<div class="col-sm-2">
					<button class="btn btn-primary btn-sm btn-block" title="Buscar Pacientes"><i class="fa fa-search"></i></button>
				</div>
				<div class="col-sm-2">
					<button type="button" class="btn btn-success btn-sm btn-block" onclick="load('app/citas/vistas/no.registrado.php','inicio=<?php echo $inicio ?>&fin=<?php echo $fin ?>&dia=<?php echo $dia ?>','#registro-cita'); cerrarAlerta('.msj_search')" title="Registro Express Pacientes"><i class="fa fa-plus"></i></button>
				</div>
			</div>
			<input type="hidden" name="inicio" value="<?php echo $inicio ?>">
			<input type="hidden" name="fin" value="<?php echo $fin ?>">
			<input type="hidden" name="dia" value="<?php echo $dia ?>">
		</form>	
		<div class="clearfix"></div>
		<div id="registro-cita"></div>
</div>
<div class="clearfix"></div>
<div class="modal-footer">
	<button class="btn btn-default cerrarmodal" data-dismiss="modal" type="button" data-bb-handler="cancel">Cancelar</button>
</div>
<script>
	$(function(){
		$('.chosen-container-multi').attr('style','width:100%')
	})
</script>