<?php 
	require'../../../cfg/base.php';
	$niv_usu = $_SESSION['niv'];
?>
<div>
	
</div>
<input type="hidden" name="niv_usu" id="niv_usu" value="<?php echo $niv_usu ?>">
<div id="calendar"></div>
<!-- PARA EVITAR CONFLICTOS ENTRE VERSIONES, SE CARGAN TANTO LOS ESTILOS COMO EL SCRIPT -->
<script>
	// document.addEventListener('DOMContentLoaded', function() {
var calendarEl = document.getElementById('calendar');

var calendar = new FullCalendar.Calendar(calendarEl, {
	height: 'auto',
	contentHeight: 'auto',
	locale: 'es',
	//timeFormat:'h:mm A', // FORMATO DE HORA QUE SE VE EN EL CINTILLO DE EVENTO
	// FORMATO DE HORA PARA EL INTERVALO DE HORA
	slotLabelFormat: {
		hour:'2-digit',
		minute:'2-digit',
	  	meridiem:'short',
	  	hour12: true,
	},
	slotLabelInterval : '01:00', // FRECUENCIA CON LA QUE SE IMPRIME EL TEXTO DE INTERVALO DE HORAS
	//slotDuration : '01:00',
	//allDaySlot : true, // Ocultar - mostar espacio de "todo el dia"
	eventLimit: true, // colocar el (mas..) cuando hay muchos eventos
	navLinks: true, // deja seleccionar el dia (cambia la vista al dia selecccionado)
	selectable: true, // Permite al usuario resaltar varios días o intervalos de tiempo haciendo clic y arrastrando.
	selectMirror: true, // Resaltar mientras el usuario arrastra o selecciona
	selectHelper: true, // Al arrastrar, se dibuja un marcador de posicion en la agenda
	// selectOverlap: false, // Impide seleccionar lapso de tiempo donde ya hay un evento creado

	// selectConstraint //  ESTUDIAR PROPIEDAD, SIRVE PARA EVITAR SELECCIONAR CAMPOS DE TIEMPO
	// selectAllow // Exacto sobre dónde puede seleccionar el usuario.
	
	nowIndicator: true, // resalta el momento actual con una linea roja (fecha y hora actual)
	views: {
	    week: {
		    titleFormat: { month: 'long', year: 'numeric', day:'numeric'},
	    },
	    day: {
	      	titleFormat: { weekday: 'long', year: 'numeric', day:'numeric'} 
	    }
	},
	plugins: [ 'dayGrid', 'timeGrid', 'interaction','momentPlugin','timeGridWeek' ],
	defaultView: 'timeGridWeek',
	header: {
	  left: 'prev,next',
	  center: 'title',
	  right: 'dayGridMonth,timeGridWeek,timeGridDay'
	},
	minTime: '05:00',
	maxTime: '22:00',
	businessHours: {
		daysOfWeek: [0,6], // resaltar todos los dias menos sabado y domingo, puede funcionar para desactivar dias ocupados?
		startTime: '05:00', // desde
		endTime: '22:00', // hasta
	},
	events: function(info, successCallback, failureCallback)  {
		$.ajax({
			method:'POST',
			cache: false,
			url: 'app/citas/procesos/p.agenda.mostrar.php',
			dataType: 'json',
			data: {
				odonto:'<?php echo $odonto ?>',
				clinica:'<?php echo $clinica ?>'
			},
			success: function(data) {
				var events = [];
				$.each(data,function(i, index) {
					hora1 = data[i].horario_hora_ini.split('.');
					hora_ini = hora1[0];
					hora2 = data[i].horario_hora_fin.split('.');
					hora_fin = hora2[0];

					events.push({
						ide : data[i].horario_ide,
						title: '- Clinica: '+data[i].clinica_descripcion+'\n - Odontólogo: '+data[i].pacien_nomraz,
						description: data[i].clinica_descripcion,
						startTime: hora_ini,
						endTime : hora_fin,
						daysOfWeek: [data[i].horario_dia_ini],
						allDay: false,
						overlap:true, // agregar eventos intermedios
						editable: false,
						startEditable:false, // no permitir aditar arrastrando el evento
						backgroundColor: '#8104ff9c',
						// ESTABLECER PROPIEDAD TIPO = 2 
						// PARA IDENTIFICAR QUE EL EVENTO PROVIENE DE TABLA HORARIOS
						// LAS TIPO 0 Y 1 PROVIENEN DE LA TABLA CITAS
						extendedProps: {
							tipo: 2
						},
					});
				});
				// BUSCAR TODOS LOS DATOS DE CITAS O EVENTOS
				$.ajax({
					method:'POST',
					cache: false,
					url: 'app/citas/procesos/p.citas.mostrar.php',
					dataType: 'json',
					data: {
						odonto:'<?php echo $odonto ?>',
						clinica:'<?php echo $clinica ?>'
					},
					success: function(data) {
						$.each(data,function(i, index) {

							if (data[i].citas_tipo == 0) {
								titulo = '- Clinica: '+data[i].clinica_descripcion+'\n - Odontólogo: '+data[i].odontologo+'\n - Paciente: '+data[i].paciente;
							} else {
								titulo = '- Lugar: '+data[i].citas_lugar+'\n - Observación: '+data[i].citas_obser;
							}
							if (data[i].citas_dia == 'false' || data[i].citas_dia == 'FALSE') {
								alldia = false;
							}else{
								alldia = true;
							}
							events.push({
								ide : data[i].citas_ide,
								title: titulo,
								start: data[i].citas_hen,
								end : data[i].citas_hsa,
								allDay: alldia,
								overlap:true,
								editable: true,
								startEditable:true, // no permitir aditar arrastrando el evento
								backgroundColor: data[i].citas_color,
								// LAS TIPO 0 Y 1 PROVIENEN DE LA TABLA CITAS
								extendedProps: {
									tipo: data[i].citas_tipo,
									cita_clinica: data[i].citas_clinica,
									cita_odonto: data[i].citas_odonto,
								},
								fechaCita: data[i].citas_fecha
							});
						});

						successCallback(events);
					},
					error: function(xhr){
						failureCallback(xhr);
					}
				},'json');

			},
			error: function(xhr){
				failureCallback(xhr);
			}
		},'json');
	},
	select: function(info) {
		if (info.allDay) {
			inicio = moment(info.start).format();
			fin = moment(info.end).format();
		}else{
			inicio = info.startStr;
			fin = info.endStr;
		}
		datos = 'odonto=<?php echo $odonto ?>&clinica=<?php echo $clinica ?>&inicio='+inicio+'&fin='+fin+'&allDay='+info.allDay;
		modal('app/citas/vistas/insertEvent.php',datos);
	},
	eventDrop: function(info) {
		inicio = moment(info.event.start).format();
		fin = moment(info.event.end).format();
		event_ide = info.event._def.extendedProps.ide;
		datos = 'odonto=<?php echo $odonto ?>&clinica=<?php echo $clinica ?>&inicio='+inicio+'&fin='+fin+'&allDay='+info.event.allDay+'&event_ide='+event_ide;
		niv_usu = $('#niv_usu').val();
		clinicacita = info.event._def.extendedProps.cita_clinica;
		odontologo = info.event._def.extendedProps.cita_odonto;
		if (niv_usu == 5) { // PARA LA SECRETARIA
			if (info.event._def.extendedProps.tipo == 0) {
				$.post('app/citas/procesos/p.validaClinica.php','odontologo='+odontologo+'&clinica='+clinicacita,function(data){
					if (data > 0) {
						if (confirm("Desea modificar el evento seleccionado?")) {
							// ACTUALIZAR EL HORARIO
							// modal('app/citas/vistas/modifiEvent.php',datos);
							$.post('app/citas/procesos/p.citas.modifi.php',datos,function(data){
								if (!isNaN(data)) {
									load('app/citas/vistas/agendaMedicos.php','odonto=<?php echo $odonto ?>&clinica=<?php echo $clinica ?>','#calendar');
									alert('Evento modificado con exito');
								}else{
									alerta('.msjerror','danger',data);
								}
							});
						}else{
							info.revert(); // REVIERTE EL CAMBIO, VUELVE EL EVENTO AL LUGAR ORGINAL			
						}
					}else{
						info.revert(); // REVIERTE EL CAMBIO, VUELVE EL EVENTO AL LUGAR ORGINAL
					}
				});
			}else if(info.event._def.extendedProps.tipo == 1){
				if (confirm("Desea modificar el evento seleccionado?")) {
					// ACTUALIZAR EL HORARIO
					// modal('app/citas/vistas/modifiEvent.php',datos);
					$.post('app/citas/procesos/p.citas.modifi.php',datos,function(data){
						if (!isNaN(data)) {
							load('app/citas/vistas/agendaMedicos.php','odonto=<?php echo $odonto ?>&clinica=<?php echo $clinica ?>','#calendar');
							alert('Evento modificado con exito');
						}else{
							alerta('.msjerror','danger',data);
						}
					});
				}else{
					info.revert(); // REVIERTE EL CAMBIO, VUELVE EL EVENTO AL LUGAR ORGINAL
				}
			}
		}else{ // DEMAS USUARIOS
			// VALIDAR QUE NO SEA TIPO 2 (PERTENECE AL HORARIO, NO SE MODIFICA)
			if (info.event._def.extendedProps.tipo != 2) {
				if (confirm("Desea modificar el evento seleccionado?")) {
					// ACTUALIZAR EL HORARIO
					// modal('app/citas/vistas/modifiEvent.php',datos);
					$.post('app/citas/procesos/p.citas.modifi.php',datos,function(data){
						if (!isNaN(data)) {
							load('app/citas/vistas/agendaMedicos.php','odonto=<?php echo $odonto ?>&clinica=<?php echo $clinica ?>','#calendar');
							alert('Evento modificado con exito');
						}else{
							alerta('.msjerror','danger',data);
						}
					});
				}else{
					info.revert(); // REVIERTE EL CAMBIO, VUELVE EL EVENTO AL LUGAR ORGINAL			
				}
			}
		}
		
	},
	eventResize:  function(info) {
		inicio = moment(info.event.start).format();
		fin = moment(info.event.end).format();
		event_ide = info.event._def.extendedProps.ide;
		niv_usu = $('#niv_usu').val();
		clinicacita = info.event._def.extendedProps.cita_clinica;
		odontologo = info.event._def.extendedProps.cita_odonto;
		datos = 'odonto=<?php echo $odonto ?>&clinica=<?php echo $clinica ?>&inicio='+inicio+'&fin='+fin+'&allDay='+info.event.allDay+'&event_ide='+event_ide;
		if (niv_usu == 5) { // PARA LA SECRETARIA
			if (info.event._def.extendedProps.tipo == 0) {
				$.post('app/citas/procesos/p.validaClinica.php','odontologo='+odontologo+'&clinica='+clinicacita,function(data){
					if (data > 0) {
						if (confirm("Desea cambiar este evento de hora?")) {
							// ACTUALIZAR EL HORARIO
							// modal('app/citas/vistas/modifiEvent.php',datos);
							$.post('app/citas/procesos/p.citas.modifi.php',datos,function(data){
								if (!isNaN(data)) {
									load('app/citas/vistas/agendaMedicos.php','odonto=<?php echo $odonto ?>&clinica=<?php echo $clinica ?>','#calendar');
									alert('Evento modificado con exito');
								}else{
									alerta('.msjerror','danger',data);
								}
							});
						}else{
							info.revert();			
						}
					}else{
						info.revert();
					}
				});
			}else if(info.event._def.extendedProps.tipo == 1){
				if (confirm("Desea cambiar este evento de hora?")) {
					// ACTUALIZAR EL HORARIO
					// modal('app/citas/vistas/modifiEvent.php',datos);
					$.post('app/citas/procesos/p.citas.modifi.php',datos,function(data){
						if (!isNaN(data)) {
							load('app/citas/vistas/agendaMedicos.php','odonto=<?php echo $odonto ?>&clinica=<?php echo $clinica ?>','#calendar');
							alert('Evento modificado con exito');
						}else{
							alerta('.msjerror','danger',data);
						}
					});
				}else{
					info.revert();			
				}
			}
		}else{ // DEMAS USUARIOS
			// VALIDAR QUE NO SEA TIPO 2 (PERTENECE AL HORARIO, NO SE MODIFICA)
			if (info.event._def.extendedProps.tipo != 2) {
				if (confirm("Desea cambiar este evento de hora?")) {
					// ACTUALIZAR EL HORARIO
					// modal('app/citas/vistas/modifiEvent.php',datos);
					$.post('app/citas/procesos/p.citas.modifi.php',datos,function(data){
						if (!isNaN(data)) {
							load('app/citas/vistas/agendaMedicos.php','odonto=<?php echo $odonto ?>&clinica=<?php echo $clinica ?>','#calendar');
							alert('Evento modificado con exito');
						}else{
							alerta('.msjerror','danger',data);
						}
					});
				}else{
					info.revert();			
				}
			}
		}
	},
	eventClick: function(info) {
		niv_usu = $('#niv_usu').val();
		inicio = moment(info.event.start).format();
		fin = moment(info.event.end).format();
		event_ide = info.event._def.extendedProps.ide;
		clinicacita = info.event._def.extendedProps.cita_clinica;
		odontologo = info.event._def.extendedProps.cita_odonto;
		datos = 'odonto=<?php echo $odonto ?>&clinica=<?php echo $clinica ?>&inicio='+inicio+'&fin='+fin+'&allDay='+info.event.allDay+'&event_ide='+event_ide;
		if (niv_usu == 5) { // PARA LA SECRETARIA
			if (info.event._def.extendedProps.tipo == 0) {
				$.post('app/citas/procesos/p.validaClinica.php','odontologo='+odontologo+'&clinica='+clinicacita,function(data){
					if (data > 0) {
						modal('app/citas/vistas/modifiEvent.php',datos);
					}
				});
			}else if(info.event._def.extendedProps.tipo == 1){
				modal('app/citas/vistas/modifiEvent.php',datos);
			}
		}else{ // DEMAS USUARIOS
			// VALIDAR QUE NO SEA TIPO 2 (PERTENECE AL HORARIO, NO SE MODIFICA)
			if (info.event._def.extendedProps.tipo != 2) {
				modal('app/citas/vistas/modifiEvent.php',datos);
			}
		}
	}
});
  calendar.render();
</script>