<?php 
class mCitas {

	protected $dbh,$con,$msj,$historia;

	function __clone() {

	} #clone

	function __construct() {
		$this->historia = new mHistoria();
		$this->dbh = new Conexion();
		$this->con = $this->dbh->pgsql();
		$this->msj = array();
		if(isset($_POST)) {
			foreach($_POST as $indice=>$valor) {
				if(!is_array($valor)) {
					$this->$indice = strtoupper($valor);
				}
			}
		}
	} #construct

	function clinicaOdonto(){
		$sql = "SELECT * from vw_clinicmed where clinicmed_med = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->odonto);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function clinicaIde($ide){
		$sql = "SELECT * FROM tbl_clinica WHERE clinica_borrado=0 and clinica_ide = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}	

	function citaNoregistrado() {
		$cedrif = $this->cedrif;
		$fecha=date('Y-m-d');
		$aten=0;
		$this->con->beginTransaction(); # Inicia la transacción
		$sql = "INSERT INTO tbl_pacien (pacien_nac,pacien_cedrif,pacien_nomraz,pacien_movil1tlf) VALUES (?,?,?,?)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->nac);
		$res->bindParam(2,$cedrif);
		$res->bindParam(3,$this->nomraz);
		$res->bindParam(4,$this->movil1tlf);	
		$exe_1 = ($res->execute()==true) ? 1 : print_r($res->errorInfo());

		$obserfin=trim($this->obser);
		$sql = "INSERT INTO tbl_citas (citas_per,citas_hen,citas_hsa,citas_dia,citas_eti,citas_fecha,citas_obser,citas_atendido,citas_silla) VALUES(?,?,?,?,?,?,?,?,?)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$cedrif);
		$res->bindParam(2,$this->inicio);
		$res->bindParam(3,$this->fin);	
		$res->bindParam(4,$this->dia);
		$res->bindParam(5,$this->etiqueta);
		$res->bindParam(6,$fecha);
		$res->bindParam(7,$obserfin);
		$res->bindParam(8,$aten);
		$res->bindParam(9,$this->silla);
		$exe_2 = ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		

		if($exe_1==true and $exe_2==true) {
			if ($exe_1==true) {
				$this->dbh->sp_auditoria($_SESSION['ced'],1,'tbl_pacien',$this->cedrif);
			}
			if ($exe_2==true) {
				$this->dbh->sp_auditoria($_SESSION['ced'],1,'tbl_citas',$this->cedrif);
			}
			$this->con->commit();
			$rt = 1;
		} else {
			$this->con->rollBack();
			$rt = print_r($res->errorInfo());
		}
		return $rt;
	}

	function citaRegistrado() {
		$obserfin=trim($this->obser);
		$sql = "INSERT INTO tbl_citas VALUES(null,?,?,?,?,?,?,?,0,?)";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->cedrif);
		$res->bindParam(2,$this->inicio);
		$res->bindParam(3,$this->fin);	
		$res->bindParam(4,$this->dia);
		$res->bindParam(5,$this->etiqueta);
		$res->bindParam(6,$this->fechacita);
		$res->bindParam(7,$obserfin);
		$res->bindParam(8,$this->silla);
		$exe_1 = ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		if ($exe_1==true) {
				$this->dbh->sp_auditoria($_SESSION['ced'],1,'tbl_citas',$this->cedrif);
			}
		return $exe_1;
	}

	function citasSelect() {
		$sql = "SELECT * FROM tbl_citas AS c 
			INNER JOIN tbl_pacien AS p on c.citas_per=p.pacien_cedrif";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function poride($ide) {
		$sql = "SELECT * FROM tbl_citas AS c 
			INNER JOIN tbl_pacien AS p on c.citas_per=p.pacien_cedrif
			WHERE citas_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function citaDelete() {
		$sql = "DELETE FROM tbl_citas WHERE citas_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->citas_ide);
		$exe_1 = $res->execute();
		$this->dbh->sp_auditoria($_SESSION['ced'],3,'tbl_citas',$this->citas_ide);
		return $exe_1;
	}

	function citaUpdate() {
		
		    $fecha_explode = explode(' ',$this->inicio);
			$mes_letra     = $fecha_explode[1];
			$dia           = $fecha_explode[2];
			$ano           = $fecha_explode[3];
			$mes           = $this->letraMes($mes_letra);
			$fecha 		   = $ano.'-'.$mes.'-'.$dia;
          
		$sql = "UPDATE tbl_citas SET citas_hen=?, citas_hsa=?, citas_dia=?,citas_fecha=? WHERE citas_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->inicio);
		$res->bindParam(2,$this->fin);
		$res->bindParam(3,$this->dia);
		$res->bindParam(4,$fecha);
		$res->bindParam(5,$this->citas_ide);
		$exe_1 = ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_citas',$this->citas_ide);
		return $exe_1;
	}

    function citaAsistio() {  
		$sql = "UPDATE tbl_citas SET citas_atendido=2 WHERE citas_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->citas_ide);
		$exe_1 = ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_citas',$this->citas_ide);
		return $exe_1;
	}

	function citaAtender() {  
		$sql = "UPDATE tbl_citas SET citas_atendido=1 WHERE citas_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->citas_ide);
		$exe_1 = ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_citas',$this->citas_ide);
		return $exe_1;
	}


    function letraMes($mes) {
		$meses = array(
				'JAN'=>'01',
				'FEB'=>'02',
				'MAR'=>'03',
				'APR'=>'04',
				'MAY'=>'05',
				'JUN'=>'06',
				'JUL'=>'07',
				'AUG'=>'08',
				'SEP'=>'09',
				'OCT'=>'10',
				'NOV'=>'11',
				'DEC'=>'12',
			);
		return $meses[$mes];
	}

	function citaPorIde($ide){
		$sql = "SELECT * FROM vw_citas_odonto WHERE citas_ide = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$ide);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function agendaOdonto($odonto,$clinica){
		$sql = "SELECT * FROM vw_horario_odonto WHERE horario_odonto = ? AND horario_clinica LIKE ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$odonto);
		$res->bindParam(2,$clinica);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function citasOdonto($odonto,$clinica){
		$sql = "SELECT * FROM vw_citas_odonto WHERE citas_odonto = ? AND (citas_clinica LIKE ? OR citas_clinica = 0) AND citas_estado = 1";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$odonto);
		$res->bindParam(2,$clinica);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function clinicaMedico($odonto){
		$sql = "SELECT * from vw_clinicmed where clinicmed_med = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$odonto);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	function clinicaMedicoAsistent($odonto,$clinica,$usu){
		$sql = "SELECT count(*) as tot from vw_listaodontoasist where asismed_med = ? and asismed_clinicaodon = ? and asismed_asis = ?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$odonto);
		$res->bindParam(2,$clinica);
		$res->bindParam(3,$usu);
		if ($res->execute()==true) {
			$resu = $res->fetchAll(PDO::FETCH_OBJ);
			$result = $resu[0]->tot;
			print_r($result);
		}else{
			$result = print_r($res->errorInfo());
		}
		return $result;
	}

	function insertCita(){
		$paciente = $this->paciente;
		if (empty($paciente)) {
			$historiaPaciente = $this->historia->historiaInsert();
			if ($historiaPaciente == 1) {
				$paciente = $this->cedrif;
			} else {
				return print_r($historiaPaciente->errorInfo());
			}
		}

		$fecha = date('Y-m-d');
		// echo "datos = <br>paciente $this->paciente <br>horaen $this->hor_ent <br>horasal $this->hor_sal <br>allDay $this->allDay <br>etiqueta $this->etiqueta <br>fecha $fecha <br>obser $this->obser <br>silla $this->silla <br>tipo $this->tipo <br>odonto $this->odonto <br>clinica $this->clinica <br>lugar $this->lugar <br>color $this->color";
		$sql = "SELECT fn_citas(0,?,?,?,?,?,?,?,0,?,?,?,?,?,?,1,?) AS res";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$paciente);
		$res->bindParam(2,$this->hor_ent);
		$res->bindParam(3,$this->hor_sal);
		$res->bindParam(4,$this->allDay);
		$res->bindParam(5,$this->etiqueta);
		$res->bindParam(6,$fecha);
		$res->bindParam(7,$this->obser);
		$res->bindParam(8,$this->silla);
		$res->bindParam(9,$this->tipo);
		$res->bindParam(10,$this->odonto);
		$res->bindParam(11,$this->clinica);
		$res->bindParam(12,$this->lugar);
		$res->bindParam(13,$this->color);
		$res->bindParam(14,$_SESSION['ced']);
		if ($res->execute()==true) {
			$resu = $res->fetchAll(PDO::FETCH_OBJ);
			$result = $resu[0]->res;
		}else{
			$result = print_r($res->errorInfo());
		}
		return $result;
	}

	function updateCita(){
		$fecha = date('Y-m-d');
		/*echo "datos = <br>paciente $this->paciente <br>horaen $this->hor_ent <br>horasal $this->hor_sal <br>allDay $this->allDay <br>etiqueta $this->etiqueta <br>fecha $fecha <br>obser $this->obser <br>silla $this->silla <br>tipo $this->tipo <br>odonto $this->odonto <br>clinica $this->clinica <br>lugar $this->lugar <br>color $this->color";*/
		$val_clinica = ($this->clinica==null) ? 1 : $this->clinica;
		$val_lugar = ($this->lugar==null) ? 1 : $this->lugar;
           
		$sql = "SELECT fn_citas(?,?,?,?,?,?,?,?,0,?,?,?,?,?,?,2,?) AS res";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->event_ide);
		$res->bindParam(2,$this->paciente);
		$res->bindParam(3,$this->hor_ent);
		$res->bindParam(4,$this->hor_sal);
		$res->bindParam(5,$this->allDay);
		$res->bindParam(6,$this->etiqueta);
		$res->bindParam(7,$fecha);
		$res->bindParam(8,$this->obser);
		$res->bindParam(9,$this->silla);
		$res->bindParam(10,$this->tipo);
		$res->bindParam(11,$this->odonto);
		$res->bindParam(12,$val_clinica);
		$res->bindParam(13,$val_lugar);
		$res->bindParam(14,$this->color);
		$res->bindParam(15,$_SESSION['ced']);
		$res->execute();
		if ($res->execute()==true) {
			$resu = $res->fetchAll(PDO::FETCH_OBJ);
			$result = $resu[0]->res;
		}else{
			$result = print_r($res->errorInfo());
		}
		return $result;
	}

	function modifyCita(){
		$sql = "SELECT fn_citas(?,0,?,?,?,0,?,0,0,0,0,0,0,0,0,4,?) AS res";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->event_ide);
		$res->bindParam(2,$this->inicio);
		$res->bindParam(3,$this->fin);
		$res->bindParam(4,$this->allDay);
		$res->bindParam(5,$this->fechaCita);
		$res->bindParam(6,$_SESSION['ced']);
		$res->execute();
		if ($res->execute()==true) {
			$resu = $res->fetchAll(PDO::FETCH_OBJ);
			$result = $resu[0]->res;
		}else{
			$result = print_r($res->errorInfo());
		}
		return $result;
	}

	function deleteCita(){
		$date = date('Y-m-d');
		$sql = "SELECT fn_citas(?,0,0,0,0,0,?,0,0,0,0,0,0,0,0,3,?) AS res";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->citas_ide);
		$res->bindParam(2,$date);
		$res->bindParam(3,$_SESSION['ced']);
		$res->execute();
		if ($res->execute()==true) {
			$resu = $res->fetchAll(PDO::FETCH_OBJ);
			$result = $resu[0]->res;
		}else{
			$result = print_r($res->errorInfo());
		}
		return $result;
	}
	public function validarBloqueCita()
	{
		$inicio = $this->hor_ent;
		$fin = $this->hor_sal;
		$sql = "SELECT citas_ide
			FROM
				tbl_citas
			WHERE
				citas_odonto = ?
			AND citas_hen BETWEEN '$inicio' AND '$fin'
			AND citas_hsa BETWEEN '$inicio' AND '$fin'";
		if (isset($this->silla) && !empty($this->silla)) {
			$sql.=" AND citas_silla = ?";
		}
		$sql.=" LIMIT 1";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->odonto);
		if (isset($this->silla) && !empty($this->silla)) {
			$res->bindParam(2,$this->silla);
		}
		$res->execute();
		if ($res->execute()==true) {
			$resu = $res->fetchAll(PDO::FETCH_OBJ);
			$result = !empty($resu) ? $resu[0] : '';
		}else{
			$result = print_r($res->errorInfo());
		}
		return $result;
	}

	function preCitas(){
		$sql = "SELECT * FROM vw_citas_odonto WHERE citas_estado = 0";
		$res = $this->con->prepare($sql);
		$res->execute();
		return $res->fetchAll(PDO::FETCH_OBJ);
	}

	public function rechazarPreagenda()
	{
		$sql = "UPDATE tbl_citas SET citas_estado=2 WHERE citas_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->preagenda_id);
		$exe_1 = ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_citas',$this->preagenda_id);
		return $exe_1;
	}

	public function confirmarPreagenda()
	{
		$sql = "UPDATE tbl_citas
				SET
					citas_eti=?,
					citas_odonto=?,
					citas_clinica=?,
					citas_silla=?,
					citas_color=?,
					citas_estado=1
				WHERE
					citas_ide=?";
		$res = $this->con->prepare($sql);
		$res->bindParam(1,$this->especialidad);
		$res->bindParam(2,$this->odontologo);
		$res->bindParam(3,$this->clinica);
		$res->bindParam(4,$this->silla);
		$res->bindParam(5,$this->color);
		$res->bindParam(6,$this->event_ide);
		$exe_1 = ($res->execute()==true) ? 1 : print_r($res->errorInfo());
		$this->dbh->sp_auditoria($_SESSION['ced'],2,'tbl_citas',$this->event_ide);
		return $exe_1;
	}
}